/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;

public class HardcodedAttributeMapper
extends AbstractLDAPStorageMapper {
    private static final Logger logger = Logger.getLogger(HardcodedAttributeMapper.class);
    private static final Map<String, Property<Object>> userModelProperties = LDAPUtils.getUserModelProperties();
    public static final String USER_MODEL_ATTRIBUTE = "user.model.attribute";
    public static final String ATTRIBUTE_VALUE = "attribute.value";

    public HardcodedAttributeMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider) {
        super(mapperModel, ldapProvider);
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        String userModelAttrName = this.getUserModelAttribute();
        String attributeValue = this.getAttributeValue();
        Property<Object> userModelProperty = userModelProperties.get(userModelAttrName.toLowerCase());
        if (userModelProperty != null) {
            this.setPropertyOnUserModel(userModelProperty, user, attributeValue);
        } else {
            user.setAttribute(userModelAttrName, Arrays.asList(attributeValue));
        }
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        final String userModelAttrName = this.getUserModelAttribute();
        final String attributeValue = this.getAttributeValue();
        delegate = new UserModelDelegate((UserModel)delegate){

            public List<String> getAttribute(String name) {
                if (userModelAttrName.equals(name)) {
                    return Arrays.asList(attributeValue);
                }
                return super.getAttribute(name);
            }

            public boolean isEmailVerified() {
                if (userModelAttrName.equals("emailVerified")) {
                    return Boolean.valueOf(attributeValue);
                }
                return super.isEmailVerified();
            }

            public boolean isEnabled() {
                if (userModelAttrName.equals("enabled")) {
                    return Boolean.valueOf(attributeValue);
                }
                return super.isEnabled();
            }
        };
        return delegate;
    }

    private String getUserModelAttribute() {
        return (String)this.mapperModel.getConfig().getFirst((Object)USER_MODEL_ATTRIBUTE);
    }

    String getAttributeValue() {
        return (String)this.mapperModel.getConfig().getFirst((Object)ATTRIBUTE_VALUE);
    }

    protected void setPropertyOnUserModel(Property<Object> userModelProperty, UserModel user, String ldapAttrValue) {
        if (ldapAttrValue == null) {
            userModelProperty.setValue((Object)user, null);
        } else {
            Class clazz = userModelProperty.getJavaClass();
            if (String.class.equals((Object)clazz)) {
                userModelProperty.setValue((Object)user, (Object)ldapAttrValue);
            } else if (Boolean.class.equals((Object)clazz) || Boolean.TYPE.equals(clazz)) {
                Boolean boolVal = Boolean.valueOf(ldapAttrValue);
                userModelProperty.setValue((Object)user, (Object)boolVal);
            } else {
                logger.warnf("Don't know how to set the property '%s' on user '%s' . Value of LDAP attribute is '%s' ", (Object)userModelProperty.getName(), (Object)user.getUsername(), (Object)ldapAttrValue.toString());
            }
        }
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
    }
}

