/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

class MergedUpdate<S extends SessionEntity>
implements SessionUpdateTask<S> {
    private List<SessionUpdateTask<S>> childUpdates = new LinkedList<SessionUpdateTask<S>>();
    private SessionUpdateTask.CacheOperation operation;
    private SessionUpdateTask.CrossDCMessageStatus crossDCMessageStatus;

    private MergedUpdate(SessionUpdateTask.CacheOperation operation, SessionUpdateTask.CrossDCMessageStatus crossDCMessageStatus) {
        this.operation = operation;
        this.crossDCMessageStatus = crossDCMessageStatus;
    }

    @Override
    public void runUpdate(S session) {
        for (SessionUpdateTask<S> child : this.childUpdates) {
            child.runUpdate(session);
        }
    }

    @Override
    public SessionUpdateTask.CacheOperation getOperation(S session) {
        return this.operation;
    }

    @Override
    public SessionUpdateTask.CrossDCMessageStatus getCrossDCMessageStatus(SessionEntityWrapper<S> sessionWrapper) {
        return this.crossDCMessageStatus;
    }

    public static <S extends SessionEntity> MergedUpdate<S> computeUpdate(List<SessionUpdateTask<S>> childUpdates, SessionEntityWrapper<S> sessionWrapper) {
        if (childUpdates == null || childUpdates.isEmpty()) {
            return null;
        }
        MergedUpdate<S> result = null;
        S session = sessionWrapper.getEntity();
        for (SessionUpdateTask<S> child : childUpdates) {
            if (result == null) {
                result = new MergedUpdate<S>(child.getOperation(session), child.getCrossDCMessageStatus(sessionWrapper));
                result.childUpdates.add(child);
                continue;
            }
            SessionUpdateTask.CacheOperation mergedOp = result.getOperation(session).merge(child.getOperation(session), (SessionEntity)session);
            if (mergedOp == SessionUpdateTask.CacheOperation.REMOVE) {
                result = new MergedUpdate<S>(child.getOperation(session), child.getCrossDCMessageStatus(sessionWrapper));
                result.childUpdates.add(child);
                return result;
            }
            result.operation = mergedOp;
            SessionUpdateTask.CrossDCMessageStatus currentDCStatus = result.getCrossDCMessageStatus(sessionWrapper);
            if (currentDCStatus != SessionUpdateTask.CrossDCMessageStatus.SYNC) {
                SessionUpdateTask.CrossDCMessageStatus childDCStatus = child.getCrossDCMessageStatus(sessionWrapper);
                result.crossDCMessageStatus = currentDCStatus.merge(childDCStatus);
            }
            result.childUpdates.add(child);
        }
        return result;
    }

    public String toString() {
        return "MergedUpdate" + this.childUpdates;
    }
}

