/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validation;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.keycloak.models.ClientModel;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.validation.ClientValidationContext;
import org.keycloak.validation.ClientValidationProvider;

public class DefaultClientValidationProvider
implements ClientValidationProvider {
    private ClientValidationContext context;

    public void validate(ClientValidationContext context) {
        this.context = context;
        try {
            this.validate(context.getClient());
        }
        catch (ValidationException e) {
            context.invalid(e.getMessage());
        }
    }

    private void validate(ClientModel client) throws ValidationException {
        String authServerUrl = "https://localhost/auth";
        String resolvedRootUrl = ResolveRelative.resolveRootUrl(authServerUrl, authServerUrl, client.getRootUrl());
        String resolvedBaseUrl = ResolveRelative.resolveRelativeUri(authServerUrl, authServerUrl, resolvedRootUrl, client.getBaseUrl());
        this.validateRootUrl(resolvedRootUrl);
        this.validateBaseUrl(resolvedBaseUrl);
    }

    private void validateRootUrl(String rootUrl) throws ValidationException {
        if (rootUrl != null && !rootUrl.isEmpty()) {
            this.basicHttpUrlCheck("rootUrl", rootUrl);
        }
    }

    private void validateBaseUrl(String baseUrl) throws ValidationException {
        if (baseUrl != null && !baseUrl.isEmpty()) {
            this.basicHttpUrlCheck("baseUrl", baseUrl);
        }
    }

    private void basicHttpUrlCheck(String field, String url) throws ValidationException {
        boolean valid = true;
        try {
            URI uri = new URL(url).toURI();
            if (uri.getScheme() == null || uri.getScheme().isEmpty()) {
                valid = false;
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            valid = false;
        }
        if (!valid) {
            throw new ValidationException("Invalid URL in " + field);
        }
    }

    class ValidationException
    extends Exception {
        public ValidationException(String message) {
            super(message, null, false, false);
        }
    }
}

