/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.List;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.ModelVersion;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.DefaultAuthenticationFlows;

public class MigrateTo1_7_0 {
    public static final ModelVersion VERSION = new ModelVersion("1.7.0");

    public void migrate(KeycloakSession session) {
        List<RealmModel> realms = session.realms().getRealms();
        for (RealmModel realm : realms) {
            realm.setAccessTokenLifespanForImplicitFlow(900);
            MigrationProvider migrationProvider = session.getProvider(MigrationProvider.class);
            migrationProvider.setupAdminCli(realm);
            DefaultAuthenticationFlows.migrateFlows(realm);
            AuthenticationFlowModel firstBrokerLoginFlow = realm.getFlowByAlias("first broker login");
            List<IdentityProviderModel> identityProviders = realm.getIdentityProviders();
            for (IdentityProviderModel identityProvider : identityProviders) {
                if (identityProvider.getFirstBrokerLoginFlowId() != null) continue;
                identityProvider.setFirstBrokerLoginFlowId(firstBrokerLoginFlow.getId());
                realm.updateIdentityProvider(identityProvider);
            }
        }
    }
}

