/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.util.List;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.Provider;

public interface CredentialProvider<T extends CredentialModel>
extends Provider {
    @Override
    default public void close() {
    }

    public String getType();

    public CredentialModel createCredential(RealmModel var1, UserModel var2, T var3);

    public boolean deleteCredential(RealmModel var1, UserModel var2, String var3);

    public T getCredentialFromModel(CredentialModel var1);

    default public T getDefaultCredential(KeycloakSession session, RealmModel realm, UserModel user) {
        List<CredentialModel> models = session.userCredentialManager().getStoredCredentialsByType(realm, user, this.getType());
        if (models.isEmpty()) {
            return null;
        }
        return this.getCredentialFromModel(models.get(0));
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext var1);
}

