/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.client;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.RealmModel;

public interface ClientLookupProvider {
    public ClientModel getClientById(RealmModel var1, String var2);

    default public ClientModel getClientById(String id, RealmModel realm) {
        return this.getClientById(realm, id);
    }

    public ClientModel getClientByClientId(RealmModel var1, String var2);

    default public ClientModel getClientByClientId(String clientId, RealmModel realm) {
        return this.getClientByClientId(realm, clientId);
    }

    @Deprecated
    default public List<ClientModel> searchClientsByClientId(String clientId, Integer firstResult, Integer maxResults, RealmModel realm) {
        return this.searchClientsByClientIdStream(realm, clientId, firstResult, maxResults).collect(Collectors.toList());
    }

    public Stream<ClientModel> searchClientsByClientIdStream(RealmModel var1, String var2, Integer var3, Integer var4);

    public Stream<ClientModel> searchClientsByAttributes(RealmModel var1, Map<String, String> var2, Integer var3, Integer var4);

    public Map<String, ClientScopeModel> getClientScopes(RealmModel var1, ClientModel var2, boolean var3);
}

