/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Set;
import java.util.function.Function;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.ThemeManager;
import org.keycloak.models.TokenManager;
import org.keycloak.models.UserCredentialManager;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.Provider;
import org.keycloak.services.clientpolicy.ClientPolicyManager;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.vault.VaultTranscriber;

public interface KeycloakSession {
    public KeycloakContext getContext();

    public KeycloakTransactionManager getTransactionManager();

    public <T extends Provider> T getProvider(Class<T> var1);

    public <T extends Provider> T getProvider(Class<T> var1, String var2);

    public <T extends Provider> T getComponentProvider(Class<T> var1, String var2);

    public <T extends Provider> T getComponentProvider(Class<T> var1, String var2, Function<KeycloakSessionFactory, ComponentModel> var3);

    public <T extends Provider> T getProvider(Class<T> var1, ComponentModel var2);

    public <T extends Provider> Set<String> listProviderIds(Class<T> var1);

    public <T extends Provider> Set<T> getAllProviders(Class<T> var1);

    public Class<? extends Provider> getProviderClass(String var1);

    public Object getAttribute(String var1);

    public <T> T getAttribute(String var1, Class<T> var2);

    default public <T> T getAttributeOrDefault(String attribute, T defaultValue) {
        Object value = this.getAttribute(attribute);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public Object removeAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public void invalidate(InvalidationHandler.InvalidableObjectType var1, Object ... var2);

    public void enlistForClose(Provider var1);

    public KeycloakSessionFactory getKeycloakSessionFactory();

    public RealmProvider realms();

    public ClientProvider clients();

    public ClientScopeProvider clientScopes();

    public GroupProvider groups();

    public RoleProvider roles();

    public UserSessionProvider sessions();

    public UserLoginFailureProvider loginFailures();

    public AuthenticationSessionProvider authenticationSessions();

    public void close();

    @Deprecated
    public UserProvider userCache();

    public UserProvider users();

    @Deprecated
    public ClientProvider clientStorageManager();

    @Deprecated
    public ClientScopeProvider clientScopeStorageManager();

    @Deprecated
    public RoleProvider roleStorageManager();

    @Deprecated
    public GroupProvider groupStorageManager();

    @Deprecated
    public UserProvider userStorageManager();

    @Deprecated
    public UserCredentialManager userCredentialManager();

    @Deprecated
    public UserProvider userLocalStorage();

    @Deprecated
    public RealmProvider realmLocalStorage();

    @Deprecated
    public ClientProvider clientLocalStorage();

    @Deprecated
    public ClientScopeProvider clientScopeLocalStorage();

    @Deprecated
    public GroupProvider groupLocalStorage();

    @Deprecated
    public RoleProvider roleLocalStorage();

    @Deprecated
    public UserFederatedStorageProvider userFederatedStorage();

    public KeyManager keys();

    public ThemeManager theme();

    public TokenManager tokens();

    public VaultTranscriber vault();

    public ClientPolicyManager clientPolicy();
}

