/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.UserModel;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class RegexPatternsPasswordPolicyProvider
implements PasswordPolicyProvider {
    private static final String ERROR_MESSAGE = "invalidPasswordRegexPatternMessage";
    private KeycloakContext context;

    public RegexPatternsPasswordPolicyProvider(KeycloakContext context) {
        this.context = context;
    }

    @Override
    public PolicyError validate(String username, String password) {
        Pattern pattern = (Pattern)this.context.getRealm().getPasswordPolicy().getPolicyConfig("regexPattern");
        Matcher matcher = pattern.matcher(password);
        if (!matcher.matches()) {
            return new PolicyError(ERROR_MESSAGE, pattern.pattern());
        }
        return null;
    }

    @Override
    public PolicyError validate(UserModel user, String password) {
        return this.validate(user.getUsername(), password);
    }

    @Override
    public Object parseConfig(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Config required");
        }
        return Pattern.compile(value);
    }

    @Override
    public void close() {
    }
}

