/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.utils.CredentialValidation;
import org.keycloak.provider.Provider;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.storage.user.UserCredentialAuthenticationProvider;
import org.keycloak.storage.user.UserCredentialValidatorProvider;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.storage.user.UserRegistrationProvider;

public class UserStorageManager
implements UserProvider {
    private static final Logger logger = Logger.getLogger(UserStorageManager.class);
    protected KeycloakSession session;

    public UserStorageManager(KeycloakSession session) {
        this.session = session;
    }

    protected UserProvider localStorage() {
        return this.session.userLocalStorage();
    }

    protected List<UserStorageProviderModel> getStorageProviders(RealmModel realm) {
        return realm.getUserStorageProviders();
    }

    protected <T> T getFirstStorageProvider(RealmModel realm, Class<T> type) {
        for (UserStorageProviderModel model : this.getStorageProviders(realm)) {
            UserStorageProviderFactory factory = (UserStorageProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, model.getProviderId());
            if (!Types.supports(type, (Object)factory, UserStorageProviderFactory.class)) continue;
            return type.cast(this.getStorageProviderInstance(model, factory));
        }
        return null;
    }

    private UserStorageProvider getStorageProviderInstance(UserStorageProviderModel model, UserStorageProviderFactory factory) {
        Object instance = (UserStorageProvider)this.session.getAttribute(model.getId());
        if (instance != null) {
            return instance;
        }
        instance = factory.create(this.session, model);
        this.session.enlistForClose((Provider)instance);
        this.session.setAttribute(model.getId(), instance);
        return instance;
    }

    protected <T> List<T> getStorageProviders(RealmModel realm, Class<T> type) {
        LinkedList<T> list = new LinkedList<T>();
        for (UserStorageProviderModel model : this.getStorageProviders(realm)) {
            UserStorageProviderFactory factory = (UserStorageProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, model.getProviderId());
            if (!Types.supports(type, (Object)factory, UserStorageProviderFactory.class)) continue;
            list.add(type.cast(this.getStorageProviderInstance(model, factory)));
        }
        return list;
    }

    @Override
    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        return this.localStorage().addUser(realm, id, username.toLowerCase(), addDefaultRoles, addDefaultRequiredActions);
    }

    @Override
    public UserModel addUser(RealmModel realm, String username) {
        UserRegistrationProvider registry = this.getFirstStorageProvider(realm, UserRegistrationProvider.class);
        if (registry != null) {
            return registry.addUser(realm, username);
        }
        return this.localStorage().addUser(realm, username.toLowerCase());
    }

    public UserStorageProvider getStorageProvider(RealmModel realm, String componentId) {
        ComponentModel model = realm.getComponent(componentId);
        if (model == null) {
            return null;
        }
        UserStorageProviderFactory factory = (UserStorageProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, model.getProviderId());
        if (factory == null) {
            throw new ModelException("Could not find UserStorageProviderFactory for: " + model.getProviderId());
        }
        return this.getStorageProviderInstance(new UserStorageProviderModel(model), factory);
    }

    @Override
    public boolean removeUser(RealmModel realm, UserModel user) {
        this.getFederatedStorage().preRemove(realm, user);
        StorageId storageId = new StorageId(user.getId());
        if (storageId.getProviderId() == null) {
            return this.localStorage().removeUser(realm, user);
        }
        UserRegistrationProvider registry = (UserRegistrationProvider)((Object)this.getStorageProvider(realm, storageId.getProviderId()));
        if (registry == null) {
            throw new ModelException("Could not resolve StorageProvider: " + storageId.getProviderId());
        }
        return registry.removeUser(realm, user);
    }

    public UserFederatedStorageProvider getFederatedStorage() {
        return this.session.userFederatedStorage();
    }

    @Override
    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        if (StorageId.isLocalStorage(user)) {
            this.localStorage().addFederatedIdentity(realm, user, socialLink);
        } else {
            this.getFederatedStorage().addFederatedIdentity(realm, user, socialLink);
        }
    }

    @Override
    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        if (StorageId.isLocalStorage(federatedUser)) {
            this.localStorage().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
        } else {
            this.getFederatedStorage().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
        }
    }

    @Override
    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        if (StorageId.isLocalStorage(user)) {
            return this.localStorage().removeFederatedIdentity(realm, user, socialProvider);
        }
        return this.getFederatedStorage().removeFederatedIdentity(realm, user, socialProvider);
    }

    @Override
    public void addConsent(RealmModel realm, UserModel user, UserConsentModel consent) {
        if (StorageId.isLocalStorage(user)) {
            this.localStorage().addConsent(realm, user, consent);
        } else {
            this.getFederatedStorage().addConsent(realm, user, consent);
        }
    }

    @Override
    public UserConsentModel getConsentByClient(RealmModel realm, UserModel user, String clientInternalId) {
        if (StorageId.isLocalStorage(user)) {
            return this.localStorage().getConsentByClient(realm, user, clientInternalId);
        }
        return this.getFederatedStorage().getConsentByClient(realm, user, clientInternalId);
    }

    @Override
    public List<UserConsentModel> getConsents(RealmModel realm, UserModel user) {
        if (StorageId.isLocalStorage(user)) {
            return this.localStorage().getConsents(realm, user);
        }
        return this.getFederatedStorage().getConsents(realm, user);
    }

    @Override
    public void updateConsent(RealmModel realm, UserModel user, UserConsentModel consent) {
        if (StorageId.isLocalStorage(user)) {
            this.localStorage().updateConsent(realm, user, consent);
        } else {
            this.getFederatedStorage().updateConsent(realm, user, consent);
        }
    }

    @Override
    public boolean revokeConsentForClient(RealmModel realm, UserModel user, String clientInternalId) {
        if (StorageId.isLocalStorage(user)) {
            return this.localStorage().revokeConsentForClient(realm, user, clientInternalId);
        }
        return this.getFederatedStorage().revokeConsentForClient(realm, user, clientInternalId);
    }

    @Override
    public UserModel getUserById(String id, RealmModel realm) {
        StorageId storageId = new StorageId(id);
        if (storageId.getProviderId() == null) {
            return this.localStorage().getUserById(id, realm);
        }
        UserLookupProvider provider = (UserLookupProvider)((Object)this.getStorageProvider(realm, storageId.getProviderId()));
        return provider.getUserById(id, realm);
    }

    @Override
    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        return this.getGroupMembers(realm, group, -1, -1);
    }

    @Override
    public UserModel getUserByUsername(String username, RealmModel realm) {
        UserModel user = this.localStorage().getUserByUsername(username, realm);
        if (user != null) {
            return user;
        }
        for (UserLookupProvider provider : this.getStorageProviders(realm, UserLookupProvider.class)) {
            user = provider.getUserByUsername(username, realm);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    @Override
    public UserModel getUserByEmail(String email, RealmModel realm) {
        UserModel user = this.localStorage().getUserByEmail(email, realm);
        if (user != null) {
            return user;
        }
        for (UserLookupProvider provider : this.getStorageProviders(realm, UserLookupProvider.class)) {
            user = provider.getUserByEmail(email, realm);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    @Override
    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        UserModel user = this.localStorage().getUserByFederatedIdentity(socialLink, realm);
        if (user != null) {
            return user;
        }
        String id = this.getFederatedStorage().getUserByFederatedIdentity(socialLink, realm);
        if (id != null) {
            return this.getUserById(id, realm);
        }
        return null;
    }

    @Override
    public UserModel getServiceAccount(ClientModel client) {
        return this.localStorage().getServiceAccount(client);
    }

    @Override
    public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
        return this.getUsers(realm, 0, 0x7FFFFFFE, includeServiceAccounts);
    }

    @Override
    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, false);
    }

    @Override
    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return this.getUsers(realm, firstResult, maxResults, false);
    }

    @Override
    public int getUsersCount(RealmModel realm) {
        int size = this.localStorage().getUsersCount(realm);
        for (UserQueryProvider provider : this.getStorageProviders(realm, UserQueryProvider.class)) {
            size += provider.getUsersCount(realm);
        }
        return size;
    }

    protected List<UserModel> query(PaginatedQuery pagedQuery, RealmModel realm, int firstResult, int maxResults) {
        if (maxResults == 0) {
            return Collections.EMPTY_LIST;
        }
        List<UserQueryProvider> storageProviders = this.getStorageProviders(realm, UserQueryProvider.class);
        if (storageProviders.isEmpty()) {
            return pagedQuery.query(this.localStorage(), firstResult, maxResults);
        }
        LinkedList<Object> providers = new LinkedList<Object>();
        LinkedList<UserModel> results = new LinkedList<UserModel>();
        providers.add(this.localStorage());
        providers.addAll(storageProviders);
        providers.add(this.getFederatedStorage());
        int leftToRead = maxResults;
        int leftToFirstResult = firstResult;
        Iterator it = providers.iterator();
        while (it.hasNext() && leftToRead != 0) {
            Object provider = it.next();
            boolean exhausted = false;
            int index = 0;
            if (leftToFirstResult > 0) {
                do {
                    int toRead = Math.min(50, leftToFirstResult);
                    List<UserModel> tmp = pagedQuery.query(provider, index, toRead);
                    leftToFirstResult -= tmp.size();
                    index += tmp.size();
                    if (tmp.size() >= toRead) continue;
                    exhausted = true;
                    break;
                } while (leftToFirstResult > 0);
            }
            if (exhausted) continue;
            List<UserModel> tmp = pagedQuery.query(provider, index, leftToRead);
            results.addAll(tmp);
            if (leftToRead <= 0) continue;
            leftToRead -= tmp.size();
        }
        return results;
    }

    @Override
    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, boolean includeServiceAccounts) {
        return this.query((provider, first, max) -> {
            if (provider instanceof UserProvider) {
                return ((UserProvider)provider).getUsers(realm, first, max, includeServiceAccounts);
            }
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).getUsers(realm, first, max);
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
    }

    @Override
    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, 0, 0x7FFFFFFE);
    }

    @Override
    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        return this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).searchForUser(search, realm, first, max);
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
    }

    @Override
    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUserByAttributes(attributes, realm, 0, 0x7FFFFFFE);
    }

    @Override
    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        return this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).searchForUserByAttributes(attributes, realm, first, max);
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
    }

    @Override
    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        List<UserModel> results = this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).searchForUserByUserAttribute(attrName, attrValue, realm);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                List<String> ids = ((UserFederatedStorageProvider)provider).getUsersByUserAttribute(realm, attrName, attrValue);
                LinkedList<UserModel> rs = new LinkedList<UserModel>();
                for (String id : ids) {
                    UserModel user = this.getUserById(id, realm);
                    if (user == null) continue;
                    rs.add(user);
                }
                return rs;
            }
            return Collections.EMPTY_LIST;
        }, realm, 0, 0x7FFFFFFE);
        return results;
    }

    @Override
    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        HashSet<FederatedIdentityModel> set = new HashSet<FederatedIdentityModel>();
        if (StorageId.isLocalStorage(user)) {
            set.addAll(this.localStorage().getFederatedIdentities(user, realm));
        }
        set.addAll(this.getFederatedStorage().getFederatedIdentities(user, realm));
        return set;
    }

    @Override
    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        FederatedIdentityModel model;
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        if (StorageId.isLocalStorage(user) && (model = this.localStorage().getFederatedIdentity(user, socialProvider, realm)) != null) {
            return model;
        }
        return this.getFederatedStorage().getFederatedIdentity(user, socialProvider, realm);
    }

    @Override
    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        List<UserRegistrationProvider> storageProviders = this.getStorageProviders(realm, UserRegistrationProvider.class);
        LinkedList<UserRegistrationProvider> providers = new LinkedList<UserRegistrationProvider>();
        providers.add(this.localStorage());
        providers.addAll(storageProviders);
        for (UserRegistrationProvider provider : providers) {
            provider.grantToAllUsers(realm, role);
        }
    }

    @Override
    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        List<UserModel> results = this.query((provider, first, max) -> {
            if (provider instanceof UserQueryProvider) {
                return ((UserQueryProvider)provider).getGroupMembers(realm, group, first, max);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                List<String> ids = ((UserFederatedStorageProvider)provider).getMembership(realm, group, first, max);
                LinkedList<UserModel> rs = new LinkedList<UserModel>();
                for (String id : ids) {
                    UserModel user = this.getUserById(id, realm);
                    if (user == null) continue;
                    rs.add(user);
                }
                return rs;
            }
            return Collections.EMPTY_LIST;
        }, realm, firstResult, maxResults);
        return results;
    }

    @Override
    public void preRemove(RealmModel realm) {
        this.localStorage().preRemove(realm);
        this.getFederatedStorage().preRemove(realm);
        for (UserStorageProvider provider : this.getStorageProviders(realm, UserStorageProvider.class)) {
            provider.preRemove(realm);
        }
    }

    @Override
    public void preRemove(RealmModel realm, UserFederationProviderModel model) {
        this.getFederatedStorage().preRemove(realm, model);
        this.localStorage().preRemove(realm, model);
    }

    @Override
    public void preRemove(RealmModel realm, GroupModel group) {
        this.localStorage().preRemove(realm, group);
        this.getFederatedStorage().preRemove(realm, group);
        for (UserStorageProvider provider : this.getStorageProviders(realm, UserStorageProvider.class)) {
            provider.preRemove(realm, group);
        }
    }

    @Override
    public void preRemove(RealmModel realm, RoleModel role) {
        this.localStorage().preRemove(realm, role);
        this.getFederatedStorage().preRemove(realm, role);
        for (UserStorageProvider provider : this.getStorageProviders(realm, UserStorageProvider.class)) {
            provider.preRemove(realm, role);
        }
    }

    @Override
    public void preRemove(RealmModel realm, ClientModel client) {
        this.localStorage().preRemove(realm, client);
        this.getFederatedStorage().preRemove(realm, client);
    }

    @Override
    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.localStorage().preRemove(protocolMapper);
        this.getFederatedStorage().preRemove(protocolMapper);
    }

    @Override
    public boolean validCredentials(KeycloakSession session, RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        if (StorageId.isLocalStorage(user)) {
            return this.localStorage().validCredentials(session, realm, user, input);
        }
        List<UserCredentialValueModel> userCreds = user.getCredentialsDirectly();
        LinkedList<UserCredentialModel> toValidate = new LinkedList<UserCredentialModel>();
        toValidate.addAll(input);
        Iterator it = toValidate.iterator();
        boolean failedStoredCredential = false;
        while (it.hasNext()) {
            UserCredentialModel cred = (UserCredentialModel)it.next();
            boolean credValidated = false;
            for (UserCredentialValueModel userCred : userCreds) {
                if (!userCred.getType().equals(cred.getType())) continue;
                if (CredentialValidation.validCredential(session, realm, user, cred)) {
                    credValidated = true;
                    break;
                }
                failedStoredCredential = true;
            }
            if (credValidated) {
                it.remove();
                continue;
            }
            if (!failedStoredCredential) continue;
            return false;
        }
        if (toValidate.isEmpty()) {
            return true;
        }
        UserStorageProvider provider = this.getStorageProvider(realm, StorageId.resolveProviderId(user));
        if (!(provider instanceof UserCredentialValidatorProvider)) {
            return false;
        }
        return ((UserCredentialValidatorProvider)((Object)provider)).validCredentials(session, realm, user, toValidate);
    }

    @Override
    public boolean validCredentials(KeycloakSession session, RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return this.validCredentials(session, realm, user, Arrays.asList(input));
    }

    @Override
    public CredentialValidationOutput validCredentials(KeycloakSession session, RealmModel realm, UserCredentialModel ... input) {
        List<UserCredentialAuthenticationProvider> providers = this.getStorageProviders(realm, UserCredentialAuthenticationProvider.class);
        if (providers.isEmpty()) {
            return CredentialValidationOutput.failed();
        }
        CredentialValidationOutput result = null;
        for (UserCredentialModel cred : input) {
            UserCredentialAuthenticationProvider providerSupportingCreds = null;
            for (UserCredentialAuthenticationProvider provider : providers) {
                if (!provider.getSupportedCredentialAuthenticationTypes().contains(cred.getType())) continue;
                providerSupportingCreds = provider;
                break;
            }
            if (providerSupportingCreds == null) {
                logger.warn((Object)("Don't have provider supporting credentials of type " + cred.getType()));
                return CredentialValidationOutput.failed();
            }
            logger.debug((Object)("Found provider [" + providerSupportingCreds + "] supporting credentials of type " + cred.getType()));
            CredentialValidationOutput currentResult = providerSupportingCreds.validCredential(session, realm, cred);
            result = result == null ? currentResult : result.merge(currentResult);
        }
        return result != null ? result : CredentialValidationOutput.failed();
    }

    @Override
    public void preRemove(RealmModel realm, ComponentModel component) {
    }

    @Override
    public void close() {
    }

    @FunctionalInterface
    static interface PaginatedQuery {
        public List<UserModel> query(Object var1, int var2, int var3);
    }
}

