/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.changeset;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.entities.AbstractIdentifiableEntity;

public class UserData {
    private String id;
    private boolean idChanged;
    private String username;
    private boolean usernameChanged;
    private Long createdTimestamp;
    private boolean createdTimestampChanged;
    private String firstName;
    private boolean firstNameChanged;
    private String lastName;
    private boolean lastNameChanged;
    private String email;
    private boolean emailChanged;
    private boolean emailVerified;
    private boolean emailVerifiedChanged;
    private boolean totp;
    private boolean totpChanged;
    private boolean enabled;
    private boolean enabledChanged;
    private Set<String> roleIds = new HashSet<String>();
    private boolean rolesChanged;
    private Set<String> groupIds = new HashSet<String>();
    private boolean groupsChanged;
    private MultivaluedHashMap<String, String> attributes = new MultivaluedHashMap();
    private boolean attributesChanged;
    private Set<String> requiredActions = new HashSet<String>();
    private boolean requiredActionsChanged;
    private List<UserCredentialValueModel> credentials = new LinkedList<UserCredentialValueModel>();
    private boolean credentialsChanged;
    private UserData original = null;

    public void rememberState() {
        this.original = new UserData();
        this.original.id = this.id;
        this.original.username = this.username;
        this.original.createdTimestamp = this.createdTimestamp;
        this.original.firstName = this.firstName;
        this.original.lastName = this.lastName;
        this.original.email = this.email;
        this.original.emailVerified = this.emailVerified;
        this.original.totp = this.totp;
        this.original.enabled = this.enabled;
        this.original.attributes.putAll(this.attributes);
        this.original.requiredActions.addAll(this.requiredActions);
        this.original.credentials.addAll(this.credentials);
    }

    public void clearChangeFlags() {
        this.original = null;
        this.idChanged = false;
        this.usernameChanged = false;
        this.createdTimestampChanged = false;
        this.firstNameChanged = false;
        this.lastNameChanged = false;
        this.emailChanged = false;
        this.emailVerifiedChanged = false;
        this.totpChanged = false;
        this.enabledChanged = false;
        this.rolesChanged = false;
        this.groupsChanged = false;
        this.attributesChanged = false;
        this.requiredActionsChanged = false;
        this.credentialsChanged = false;
    }

    public boolean isChanged() {
        return !this.idChanged && !this.usernameChanged && !this.createdTimestampChanged && !this.firstNameChanged && !this.lastNameChanged && !this.emailChanged && !this.emailVerifiedChanged && !this.totpChanged && !this.enabledChanged && !this.rolesChanged && !this.groupsChanged && !this.attributesChanged && !this.requiredActionsChanged && !this.credentialsChanged;
    }

    public boolean isIdChanged() {
        return this.idChanged;
    }

    public boolean isUsernameChanged() {
        return this.usernameChanged;
    }

    public boolean isCreatedTimestampChanged() {
        return this.createdTimestampChanged;
    }

    public boolean isFirstNameChanged() {
        return this.firstNameChanged;
    }

    public boolean isLastNameChanged() {
        return this.lastNameChanged;
    }

    public boolean isEmailChanged() {
        return this.emailChanged;
    }

    public boolean isEmailVerifiedChanged() {
        return this.emailVerifiedChanged;
    }

    public boolean isTotpChanged() {
        return this.totpChanged;
    }

    public boolean isEnabledChanged() {
        return this.enabledChanged;
    }

    public boolean isRolesChanged() {
        return this.rolesChanged;
    }

    public boolean isGroupsChanged() {
        return this.groupsChanged;
    }

    public boolean isAttributesChanged() {
        return this.attributesChanged;
    }

    public boolean isRequiredActionsChanged() {
        return this.requiredActionsChanged;
    }

    public boolean isCredentialsChanged() {
        return this.credentialsChanged;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.idChanged = true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.usernameChanged = true;
    }

    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(Long timestamp) {
        this.createdTimestamp = timestamp;
        this.createdTimestampChanged = true;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
        this.firstNameChanged = true;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
        this.lastNameChanged = true;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
        this.emailChanged = true;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public void setEmailVerified(boolean emailVerified) {
        this.emailVerified = emailVerified;
        this.emailVerifiedChanged = true;
    }

    public boolean isTotp() {
        return this.totp;
    }

    public void setTotp(boolean totp) {
        this.totp = totp;
        this.totpChanged = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.enabledChanged = true;
    }

    public Set<String> getRoleMappings() {
        return Collections.unmodifiableSet(this.roleIds);
    }

    public void grantRole(String roleId) {
        if (this.roleIds.contains(roleId)) {
            return;
        }
        this.roleIds.add(roleId);
        this.rolesChanged = true;
    }

    public void deleteRoleMapping(String roleId) {
        if (!this.roleIds.contains(roleId)) {
            return;
        }
        this.roleIds.remove(roleId);
        this.rolesChanged = true;
    }

    public MultivaluedHashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public void setSingleAttribute(String name, String value) {
        this.attributes.putSingle((Object)name, (Object)value);
        this.attributesChanged = true;
    }

    public void setAttribute(String name, List<String> values) {
        this.attributes.put((Object)name, values);
        this.attributesChanged = true;
    }

    public void removeAttribute(String name) {
        this.attributes.remove((Object)name);
        this.attributesChanged = true;
    }

    public Set<String> getRequiredActions() {
        return Collections.unmodifiableSet(this.requiredActions);
    }

    public void addRequiredAction(String action) {
        if (this.requiredActions.contains(action)) {
            return;
        }
        this.requiredActions.add(action);
        this.requiredActionsChanged = true;
    }

    public void removeRequiredAction(String action) {
        if (!this.requiredActions.contains(action)) {
            return;
        }
        this.requiredActions.remove(action);
        this.requiredActionsChanged = true;
    }

    public List<UserCredentialValueModel> getCredentials() {
        return Collections.unmodifiableList(this.credentials);
    }

    public void removeCredentialType(String type) {
        Iterator<UserCredentialValueModel> it = this.credentials.iterator();
        while (it.hasNext()) {
            if (!it.next().getType().equals(type)) continue;
            it.remove();
            this.credentialsChanged = true;
        }
    }

    public void removeCredentialDevice(String type, String device) {
        Iterator<UserCredentialValueModel> it = this.credentials.iterator();
        while (it.hasNext()) {
            UserCredentialValueModel next = it.next();
            if (!next.getType().equals(type) || !next.getDevice().equals(device)) continue;
            it.remove();
            this.credentialsChanged = true;
        }
    }

    public void setCredential(UserCredentialValueModel cred) {
        this.removeCredentialType(cred.getType());
        this.addCredential(cred);
    }

    public void addCredential(UserCredentialValueModel cred) {
        this.credentials.add(cred);
        this.credentialsChanged = true;
    }

    public Set<String> getGroupIds() {
        return Collections.unmodifiableSet(this.groupIds);
    }

    public void joinGroup(String groupId) {
        if (this.groupIds.contains(groupId)) {
            return;
        }
        this.groupIds.add(groupId);
        this.groupsChanged = true;
    }

    public void leaveGroup(String groupId) {
        if (!this.groupIds.contains(groupId)) {
            return;
        }
        this.groupIds.remove(groupId);
        this.groupsChanged = true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractIdentifiableEntity that = (AbstractIdentifiableEntity)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public String toString() {
        return String.format("%s [ id=%s ]", this.getClass().getSimpleName(), this.getId());
    }
}

