/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RoleModel;

public class UserConsentModel {
    private final ClientModel client;
    private Set<ProtocolMapperModel> protocolMappers = new HashSet<ProtocolMapperModel>();
    private Set<RoleModel> roles = new HashSet<RoleModel>();
    private Long createdDate;
    private Long lastUpdatedDate;

    public UserConsentModel(ClientModel client) {
        this.client = client;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public void addGrantedRole(RoleModel role) {
        this.roles.add(role);
    }

    public Set<RoleModel> getGrantedRoles() {
        return this.roles;
    }

    public boolean isRoleGranted(RoleModel role) {
        for (RoleModel currentRole : this.roles) {
            if (!currentRole.getId().equals(role.getId())) continue;
            return true;
        }
        return false;
    }

    public void addGrantedProtocolMapper(ProtocolMapperModel protocolMapper) {
        this.protocolMappers.add(protocolMapper);
    }

    public Set<ProtocolMapperModel> getGrantedProtocolMappers() {
        return this.protocolMappers;
    }

    public boolean isProtocolMapperGranted(ProtocolMapperModel protocolMapper) {
        for (ProtocolMapperModel currentProtMapper : this.protocolMappers) {
            if (!currentProtMapper.getId().equals(protocolMapper.getId())) continue;
            return true;
        }
        return false;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public Long getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Long lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }
}

