/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.user;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.user.UserQueryMethodsProvider;

public interface UserCountMethodsProvider {
    default public int getUsersCount(RealmModel realm) {
        return this.getUsersCount(realm, false);
    }

    default public int getUsersCount(RealmModel realm, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty() || !(this instanceof UserQueryMethodsProvider)) {
            return 0;
        }
        return UserCountMethodsProvider.countUsersInGroups(((UserQueryMethodsProvider)((Object)this)).searchForUserStream(realm, Collections.emptyMap()), groupIds);
    }

    @Deprecated
    default public int getUsersCount(RealmModel realm, String search) {
        if (!(this instanceof UserQueryMethodsProvider)) {
            return 0;
        }
        return (int)((UserQueryMethodsProvider)((Object)this)).searchForUserStream(realm, search).count();
    }

    @Deprecated
    default public int getUsersCount(RealmModel realm, String search, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty() || !(this instanceof UserQueryMethodsProvider)) {
            return 0;
        }
        return UserCountMethodsProvider.countUsersInGroups(((UserQueryMethodsProvider)((Object)this)).searchForUserStream(realm, search), groupIds);
    }

    default public int getUsersCount(RealmModel realm, Map<String, String> params) {
        if (!(this instanceof UserQueryMethodsProvider)) {
            return 0;
        }
        return (int)((UserQueryMethodsProvider)((Object)this)).searchForUserStream(realm, params).count();
    }

    default public int getUsersCount(RealmModel realm, Map<String, String> params, Set<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty() || !(this instanceof UserQueryMethodsProvider)) {
            return 0;
        }
        return UserCountMethodsProvider.countUsersInGroups(((UserQueryMethodsProvider)((Object)this)).searchForUserStream(realm, params), groupIds);
    }

    public static int countUsersInGroups(Stream<UserModel> users, Set<String> groupIds) {
        return (int)users.filter(u -> u.getGroupsStream().map(GroupModel::getId).anyMatch(groupIds::contains)).count();
    }

    default public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        throw new RuntimeException("Not implemented");
    }
}

