/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.io.Serializable;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.UserModel;

public class StorageId
implements Serializable {
    private String id;
    private String providerId;
    private String externalId;

    public StorageId(String id) {
        this.id = id;
        if (!id.startsWith("f:")) {
            this.externalId = id;
            return;
        }
        int providerIndex = id.indexOf(58, 2);
        this.providerId = id.substring(2, providerIndex);
        this.externalId = id.substring(providerIndex + 1);
    }

    public StorageId(String providerId, String externalId) {
        this.id = "f:" + providerId + ":" + externalId;
        this.providerId = providerId;
        this.externalId = externalId;
    }

    public static String keycloakId(ComponentModel model, String externalId) {
        return new StorageId(model.getId(), externalId).getId();
    }

    public static String externalId(String keycloakId) {
        return new StorageId(keycloakId).getExternalId();
    }

    public static String providerId(String keycloakId) {
        return new StorageId(keycloakId).getProviderId();
    }

    public static String resolveProviderId(UserModel user) {
        return new StorageId(user.getId()).getProviderId();
    }

    public static boolean isLocalStorage(UserModel user) {
        return new StorageId(user.getId()).getProviderId() == null;
    }

    public static boolean isLocalStorage(String userId) {
        return new StorageId(userId).getProviderId() == null;
    }

    public boolean isLocal() {
        return this.getProviderId() == null;
    }

    public String getId() {
        return this.id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getExternalId() {
        return this.externalId;
    }
}

