/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;

public interface RealmModel
extends RoleContainerModel {
    @Override
    public String getId();

    public String getName();

    public void setName(String var1);

    public String getDisplayName();

    public void setDisplayName(String var1);

    public String getDisplayNameHtml();

    public void setDisplayNameHtml(String var1);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public SslRequired getSslRequired();

    public void setSslRequired(SslRequired var1);

    public boolean isRegistrationAllowed();

    public void setRegistrationAllowed(boolean var1);

    public boolean isRegistrationEmailAsUsername();

    public void setRegistrationEmailAsUsername(boolean var1);

    public boolean isRememberMe();

    public void setRememberMe(boolean var1);

    public boolean isEditUsernameAllowed();

    public void setEditUsernameAllowed(boolean var1);

    public void setAttribute(String var1, String var2);

    public void setAttribute(String var1, Boolean var2);

    public void setAttribute(String var1, Integer var2);

    public void setAttribute(String var1, Long var2);

    public void removeAttribute(String var1);

    public String getAttribute(String var1);

    public Integer getAttribute(String var1, Integer var2);

    public Long getAttribute(String var1, Long var2);

    public Boolean getAttribute(String var1, Boolean var2);

    public Map<String, String> getAttributes();

    public boolean isBruteForceProtected();

    public void setBruteForceProtected(boolean var1);

    public boolean isPermanentLockout();

    public void setPermanentLockout(boolean var1);

    public int getMaxFailureWaitSeconds();

    public void setMaxFailureWaitSeconds(int var1);

    public int getWaitIncrementSeconds();

    public void setWaitIncrementSeconds(int var1);

    public int getMinimumQuickLoginWaitSeconds();

    public void setMinimumQuickLoginWaitSeconds(int var1);

    public long getQuickLoginCheckMilliSeconds();

    public void setQuickLoginCheckMilliSeconds(long var1);

    public int getMaxDeltaTimeSeconds();

    public void setMaxDeltaTimeSeconds(int var1);

    public int getFailureFactor();

    public void setFailureFactor(int var1);

    public boolean isVerifyEmail();

    public void setVerifyEmail(boolean var1);

    public boolean isLoginWithEmailAllowed();

    public void setLoginWithEmailAllowed(boolean var1);

    public boolean isDuplicateEmailsAllowed();

    public void setDuplicateEmailsAllowed(boolean var1);

    public boolean isResetPasswordAllowed();

    public void setResetPasswordAllowed(boolean var1);

    public boolean isRevokeRefreshToken();

    public void setRevokeRefreshToken(boolean var1);

    public int getSsoSessionIdleTimeout();

    public void setSsoSessionIdleTimeout(int var1);

    public int getSsoSessionMaxLifespan();

    public void setSsoSessionMaxLifespan(int var1);

    public int getOfflineSessionIdleTimeout();

    public void setOfflineSessionIdleTimeout(int var1);

    public int getAccessTokenLifespan();

    public void setAccessTokenLifespan(int var1);

    public int getAccessTokenLifespanForImplicitFlow();

    public void setAccessTokenLifespanForImplicitFlow(int var1);

    public int getAccessCodeLifespan();

    public void setAccessCodeLifespan(int var1);

    public int getAccessCodeLifespanUserAction();

    public void setAccessCodeLifespanUserAction(int var1);

    public int getAccessCodeLifespanLogin();

    public void setAccessCodeLifespanLogin(int var1);

    public int getActionTokenGeneratedByAdminLifespan();

    public void setActionTokenGeneratedByAdminLifespan(int var1);

    public int getActionTokenGeneratedByUserLifespan();

    public void setActionTokenGeneratedByUserLifespan(int var1);

    public List<RequiredCredentialModel> getRequiredCredentials();

    public void addRequiredCredential(String var1);

    public PasswordPolicy getPasswordPolicy();

    public void setPasswordPolicy(PasswordPolicy var1);

    public OTPPolicy getOTPPolicy();

    public void setOTPPolicy(OTPPolicy var1);

    public RoleModel getRoleById(String var1);

    public List<GroupModel> getDefaultGroups();

    public void addDefaultGroup(GroupModel var1);

    public void removeDefaultGroup(GroupModel var1);

    public List<ClientModel> getClients();

    public ClientModel addClient(String var1);

    public ClientModel addClient(String var1, String var2);

    public boolean removeClient(String var1);

    public ClientModel getClientById(String var1);

    public ClientModel getClientByClientId(String var1);

    public void updateRequiredCredentials(Set<String> var1);

    public Map<String, String> getBrowserSecurityHeaders();

    public void setBrowserSecurityHeaders(Map<String, String> var1);

    public Map<String, String> getSmtpConfig();

    public void setSmtpConfig(Map<String, String> var1);

    public AuthenticationFlowModel getBrowserFlow();

    public void setBrowserFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getRegistrationFlow();

    public void setRegistrationFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getDirectGrantFlow();

    public void setDirectGrantFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getResetCredentialsFlow();

    public void setResetCredentialsFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getClientAuthenticationFlow();

    public void setClientAuthenticationFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getDockerAuthenticationFlow();

    public void setDockerAuthenticationFlow(AuthenticationFlowModel var1);

    public List<AuthenticationFlowModel> getAuthenticationFlows();

    public AuthenticationFlowModel getFlowByAlias(String var1);

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel var1);

    public AuthenticationFlowModel getAuthenticationFlowById(String var1);

    public void removeAuthenticationFlow(AuthenticationFlowModel var1);

    public void updateAuthenticationFlow(AuthenticationFlowModel var1);

    public List<AuthenticationExecutionModel> getAuthenticationExecutions(String var1);

    public AuthenticationExecutionModel getAuthenticationExecutionById(String var1);

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel var1);

    public void updateAuthenticatorExecution(AuthenticationExecutionModel var1);

    public void removeAuthenticatorExecution(AuthenticationExecutionModel var1);

    public List<AuthenticatorConfigModel> getAuthenticatorConfigs();

    public AuthenticatorConfigModel addAuthenticatorConfig(AuthenticatorConfigModel var1);

    public void updateAuthenticatorConfig(AuthenticatorConfigModel var1);

    public void removeAuthenticatorConfig(AuthenticatorConfigModel var1);

    public AuthenticatorConfigModel getAuthenticatorConfigById(String var1);

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(String var1);

    public List<RequiredActionProviderModel> getRequiredActionProviders();

    public RequiredActionProviderModel addRequiredActionProvider(RequiredActionProviderModel var1);

    public void updateRequiredActionProvider(RequiredActionProviderModel var1);

    public void removeRequiredActionProvider(RequiredActionProviderModel var1);

    public RequiredActionProviderModel getRequiredActionProviderById(String var1);

    public RequiredActionProviderModel getRequiredActionProviderByAlias(String var1);

    public List<IdentityProviderModel> getIdentityProviders();

    public IdentityProviderModel getIdentityProviderByAlias(String var1);

    public void addIdentityProvider(IdentityProviderModel var1);

    public void removeIdentityProviderByAlias(String var1);

    public void updateIdentityProvider(IdentityProviderModel var1);

    public Set<IdentityProviderMapperModel> getIdentityProviderMappers();

    public Set<IdentityProviderMapperModel> getIdentityProviderMappersByAlias(String var1);

    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel var1);

    public void removeIdentityProviderMapper(IdentityProviderMapperModel var1);

    public void updateIdentityProviderMapper(IdentityProviderMapperModel var1);

    public IdentityProviderMapperModel getIdentityProviderMapperById(String var1);

    public IdentityProviderMapperModel getIdentityProviderMapperByName(String var1, String var2);

    public ComponentModel addComponentModel(ComponentModel var1);

    public ComponentModel importComponentModel(ComponentModel var1);

    public void updateComponent(ComponentModel var1);

    public void removeComponent(ComponentModel var1);

    public void removeComponents(String var1);

    public List<ComponentModel> getComponents(String var1, String var2);

    public List<ComponentModel> getComponents(String var1);

    public List<ComponentModel> getComponents();

    public ComponentModel getComponent(String var1);

    default public List<UserStorageProviderModel> getUserStorageProviders() {
        LinkedList<UserStorageProviderModel> list = new LinkedList<UserStorageProviderModel>();
        for (ComponentModel component : this.getComponents(this.getId(), UserStorageProvider.class.getName())) {
            list.add(new UserStorageProviderModel(component));
        }
        Collections.sort(list, UserStorageProviderModel.comparator);
        return list;
    }

    public String getLoginTheme();

    public void setLoginTheme(String var1);

    public String getAccountTheme();

    public void setAccountTheme(String var1);

    public String getAdminTheme();

    public void setAdminTheme(String var1);

    public String getEmailTheme();

    public void setEmailTheme(String var1);

    public int getNotBefore();

    public void setNotBefore(int var1);

    public boolean isEventsEnabled();

    public void setEventsEnabled(boolean var1);

    public long getEventsExpiration();

    public void setEventsExpiration(long var1);

    public Set<String> getEventsListeners();

    public void setEventsListeners(Set<String> var1);

    public Set<String> getEnabledEventTypes();

    public void setEnabledEventTypes(Set<String> var1);

    public boolean isAdminEventsEnabled();

    public void setAdminEventsEnabled(boolean var1);

    public boolean isAdminEventsDetailsEnabled();

    public void setAdminEventsDetailsEnabled(boolean var1);

    public ClientModel getMasterAdminClient();

    public void setMasterAdminClient(ClientModel var1);

    public boolean isIdentityFederationEnabled();

    public boolean isInternationalizationEnabled();

    public void setInternationalizationEnabled(boolean var1);

    public Set<String> getSupportedLocales();

    public void setSupportedLocales(Set<String> var1);

    public String getDefaultLocale();

    public void setDefaultLocale(String var1);

    public GroupModel createGroup(String var1);

    public GroupModel createGroup(String var1, String var2);

    public GroupModel getGroupById(String var1);

    public List<GroupModel> getGroups();

    public List<GroupModel> getTopLevelGroups();

    public boolean removeGroup(GroupModel var1);

    public void moveGroup(GroupModel var1, GroupModel var2);

    public List<ClientTemplateModel> getClientTemplates();

    public ClientTemplateModel addClientTemplate(String var1);

    public ClientTemplateModel addClientTemplate(String var1, String var2);

    public boolean removeClientTemplate(String var1);

    public ClientTemplateModel getClientTemplateById(String var1);

    public static interface IdentityProviderRemovedEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public IdentityProviderModel getRemovedIdentityProvider();

        public KeycloakSession getKeycloakSession();
    }

    public static interface IdentityProviderUpdatedEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public IdentityProviderModel getUpdatedIdentityProvider();

        public KeycloakSession getKeycloakSession();
    }

    public static interface ClientRemovedEvent
    extends ProviderEvent {
        public ClientModel getClient();

        public KeycloakSession getKeycloakSession();
    }

    public static interface ClientUpdatedEvent
    extends ProviderEvent {
        public ClientModel getUpdatedClient();

        public KeycloakSession getKeycloakSession();
    }

    public static interface ClientCreationEvent
    extends ProviderEvent {
        public ClientModel getCreatedClient();
    }

    public static interface RealmRemovedEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public KeycloakSession getKeycloakSession();
    }

    public static interface RealmPostCreateEvent
    extends ProviderEvent {
        public RealmModel getCreatedRealm();

        public KeycloakSession getKeycloakSession();
    }

    public static interface RealmCreationEvent
    extends ProviderEvent {
        public RealmModel getCreatedRealm();
    }
}

