/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Map;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.ScopeContainerModel;

public interface ClientScopeModel
extends ProtocolMapperContainerModel,
ScopeContainerModel {
    public static final String DISPLAY_ON_CONSENT_SCREEN = "display.on.consent.screen";
    public static final String CONSENT_SCREEN_TEXT = "consent.screen.text";

    public String getId();

    public String getName();

    public RealmModel getRealm();

    public void setName(String var1);

    public String getDescription();

    public void setDescription(String var1);

    public String getProtocol();

    public void setProtocol(String var1);

    public void setAttribute(String var1, String var2);

    public void removeAttribute(String var1);

    public String getAttribute(String var1);

    public Map<String, String> getAttributes();

    default public boolean isDisplayOnConsentScreen() {
        String displayVal = this.getAttribute(DISPLAY_ON_CONSENT_SCREEN);
        return displayVal == null ? true : Boolean.parseBoolean(displayVal);
    }

    default public void setDisplayOnConsentScreen(boolean displayOnConsentScreen) {
        this.setAttribute(DISPLAY_ON_CONSENT_SCREEN, String.valueOf(displayOnConsentScreen));
    }

    default public String getConsentScreenText() {
        String consentScreenText = this.getAttribute(CONSENT_SCREEN_TEXT);
        if (consentScreenText == null) {
            consentScreenText = this.getName();
        }
        return consentScreenText;
    }

    default public void setConsentScreenText(String consentScreenText) {
        this.setAttribute(CONSENT_SCREEN_TEXT, consentScreenText);
    }
}

