/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Nationalized;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RoleAttributeEntity;

@Entity
@Table(name="KEYCLOAK_ROLE", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "CLIENT_REALM_CONSTRAINT"})})
@NamedQueries(value={@NamedQuery(name="getClientRoles", query="select role from RoleEntity role where role.clientId = :client order by role.name"), @NamedQuery(name="getClientRoleIds", query="select role.id from RoleEntity role where role.clientId = :client"), @NamedQuery(name="getClientRoleByName", query="select role from RoleEntity role where role.name = :name and role.clientId = :client"), @NamedQuery(name="getClientRoleIdByName", query="select role.id from RoleEntity role where role.name = :name and role.clientId = :client"), @NamedQuery(name="searchForClientRoles", query="select role from RoleEntity role where role.clientId = :client and ( lower(role.name) like :search or lower(role.description) like :search ) order by role.name"), @NamedQuery(name="getRealmRoles", query="select role from RoleEntity role where role.clientRole = false and role.realm.id = :realm order by role.name"), @NamedQuery(name="getRealmRoleIds", query="select role.id from RoleEntity role where role.clientRole = false and role.realm.id = :realm"), @NamedQuery(name="getRealmRoleByName", query="select role from RoleEntity role where role.clientRole = false and role.name = :name and role.realm = :realm"), @NamedQuery(name="getRealmRoleIdByName", query="select role.id from RoleEntity role where role.clientRole = false and role.name = :name and role.realm.id = :realm"), @NamedQuery(name="searchForRealmRoles", query="select role from RoleEntity role where role.clientRole = false and role.realm.id = :realm and ( lower(role.name) like :search or lower(role.description) like :search ) order by role.name")})
public class RoleEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    private String id;
    @Nationalized
    @Column(name="NAME")
    private String name;
    @Nationalized
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="REALM_ID")
    private String realmId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="REALM")
    private RealmEntity realm;
    @Column(name="CLIENT_ROLE")
    private boolean clientRole;
    @Column(name="CLIENT")
    private String clientId;
    @Column(name="CLIENT_REALM_CONSTRAINT", length=36)
    private String clientRealmConstraint;
    @ManyToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="COMPOSITE_ROLE", joinColumns={@JoinColumn(name="COMPOSITE")}, inverseJoinColumns={@JoinColumn(name="CHILD_ROLE")})
    private Set<RoleEntity> compositeRoles;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="role")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected List<RoleAttributeEntity> attributes;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getRealmId() {
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_write_realmId(realmId);
    }

    public List<RoleAttributeEntity> getAttributes() {
        if (this.$$_hibernate_read_attributes() == null) {
            this.$$_hibernate_write_attributes(new LinkedList());
        }
        return this.$$_hibernate_read_attributes();
    }

    public void setAttributes(List<RoleAttributeEntity> attributes) {
        this.$$_hibernate_write_attributes(attributes);
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public String getDescription() {
        return this.$$_hibernate_read_description();
    }

    public void setDescription(String description) {
        this.$$_hibernate_write_description(description);
    }

    public Set<RoleEntity> getCompositeRoles() {
        if (this.$$_hibernate_read_compositeRoles() == null) {
            this.$$_hibernate_write_compositeRoles(new HashSet());
        }
        return this.$$_hibernate_read_compositeRoles();
    }

    public void setCompositeRoles(Set<RoleEntity> compositeRoles) {
        this.$$_hibernate_write_compositeRoles(compositeRoles);
    }

    public boolean isClientRole() {
        return this.$$_hibernate_read_clientRole();
    }

    public void setClientRole(boolean clientRole) {
        this.$$_hibernate_write_clientRole(clientRole);
    }

    public RealmEntity getRealm() {
        return this.$$_hibernate_read_realm();
    }

    public void setRealm(RealmEntity realm) {
        this.$$_hibernate_write_realm(realm);
        this.$$_hibernate_write_clientRealmConstraint(realm.getId());
    }

    public String getClientId() {
        return this.$$_hibernate_read_clientId();
    }

    public void setClientId(String clientId) {
        this.$$_hibernate_write_clientId(clientId);
        this.$$_hibernate_write_clientRealmConstraint(clientId);
    }

    public String getClientRealmConstraint() {
        return this.$$_hibernate_read_clientRealmConstraint();
    }

    public void setClientRealmConstraint(String clientRealmConstraint) {
        this.$$_hibernate_write_clientRealmConstraint(clientRealmConstraint);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof RoleEntity)) {
            return false;
        }
        RoleEntity that = (RoleEntity)o;
        return this.$$_hibernate_read_id().equals(that.getId());
    }

    public int hashCode() {
        return this.$$_hibernate_read_id().hashCode();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        RoleEntity roleEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        block0: {
            if (this.$$_hibernate_tracker == null) break block0;
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        RoleEntity roleEntity = this;
        roleEntity = null;
        roleEntity = NoopCollectionTracker.INSTANCE;
        return roleEntity;
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!Objects.deepEquals(string, this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_description() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "description", (Object)this.description);
        }
        return this.description;
    }

    public void $$_hibernate_write_description(String string) {
        if (!Objects.deepEquals(string, this.description)) {
            this.$$_hibernate_trackChange("description");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "description", (Object)this.description, (Object)string);
            return;
        }
        this.description = string;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (!Objects.deepEquals(string, this.realmId)) {
            this.$$_hibernate_trackChange("realmId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public RealmEntity $$_hibernate_read_realm() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realm = (RealmEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "realm", (Object)this.realm);
        }
        return this.realm;
    }

    public void $$_hibernate_write_realm(RealmEntity realmEntity) {
        if (!Objects.deepEquals(realmEntity, this.realm)) {
            this.$$_hibernate_trackChange("realm");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realm = (RealmEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realm", (Object)this.realm, (Object)realmEntity);
            return;
        }
        this.realm = realmEntity;
    }

    public boolean $$_hibernate_read_clientRole() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientRole = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "clientRole", this.clientRole);
        }
        return this.clientRole;
    }

    public void $$_hibernate_write_clientRole(boolean bl) {
        if (bl - this.clientRole != 0) {
            this.$$_hibernate_trackChange("clientRole");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientRole = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "clientRole", this.clientRole, bl);
            return;
        }
        this.clientRole = bl;
    }

    public String $$_hibernate_read_clientId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientId", (Object)this.clientId);
        }
        return this.clientId;
    }

    public void $$_hibernate_write_clientId(String string) {
        if (!Objects.deepEquals(string, this.clientId)) {
            this.$$_hibernate_trackChange("clientId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientId", (Object)this.clientId, (Object)string);
            return;
        }
        this.clientId = string;
    }

    public String $$_hibernate_read_clientRealmConstraint() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientRealmConstraint = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientRealmConstraint", (Object)this.clientRealmConstraint);
        }
        return this.clientRealmConstraint;
    }

    public void $$_hibernate_write_clientRealmConstraint(String string) {
        if (!Objects.deepEquals(string, this.clientRealmConstraint)) {
            this.$$_hibernate_trackChange("clientRealmConstraint");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientRealmConstraint = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientRealmConstraint", (Object)this.clientRealmConstraint, (Object)string);
            return;
        }
        this.clientRealmConstraint = string;
    }

    public Set $$_hibernate_read_compositeRoles() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.compositeRoles = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "compositeRoles", this.compositeRoles);
        }
        return this.compositeRoles;
    }

    public void $$_hibernate_write_compositeRoles(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.compositeRoles = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "compositeRoles", this.compositeRoles, (Object)set);
            return;
        }
        this.compositeRoles = set;
    }

    public List $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }

    public void $$_hibernate_write_attributes(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "attributes", this.attributes, (Object)list);
            return;
        }
        this.attributes = list;
    }
}

