/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.Config;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.resources.AttributeFormDataProcessor;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.profile.DefaultUserProfileContext;
import org.keycloak.userprofile.profile.representations.AttributeUserProfile;
import org.keycloak.userprofile.utils.UserUpdateHelper;
import org.keycloak.userprofile.validation.UserProfileValidationResult;

public class RegistrationProfile
implements FormAction,
FormActionFactory {
    public static final String PROVIDER_ID = "registration-profile-action";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getHelpText() {
        return "Validates email, first name, and last name attributes and stores them in user data.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void validate(ValidationContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        AttributeUserProfile updatedProfile = AttributeFormDataProcessor.toUserProfile((MultivaluedMap<String, String>)formData);
        UserProfileProvider userProfile = (UserProfileProvider)context.getSession().getProvider(UserProfileProvider.class, "legacy-user-profile");
        context.getEvent().detail("register_method", "form");
        UserProfileValidationResult result = userProfile.validate((UserProfileContext)DefaultUserProfileContext.forRegistrationProfile(), (UserProfile)updatedProfile);
        List<FormMessage> errors = Validation.getFormErrorsFromValidation(result);
        if (errors.size() > 0) {
            if (result.hasFailureOfErrorType(new String[]{"emailExistsMessage", "invalidEmailMessage"})) {
                context.getEvent().detail("email", updatedProfile.getAttributes().getFirstAttribute("email"));
            }
            if (result.hasFailureOfErrorType(new String[]{"emailExistsMessage"})) {
                context.error("email_in_use");
                formData.remove((Object)"email");
            } else {
                context.error("invalid_registration");
            }
            context.validationError(formData, errors);
            return;
        }
        context.success();
    }

    public void success(FormContext context) {
        UserModel user = context.getUser();
        AttributeUserProfile updatedProfile = AttributeFormDataProcessor.toUserProfile((MultivaluedMap<String, String>)context.getHttpRequest().getDecodedFormParameters());
        UserUpdateHelper.updateRegistrationProfile(context.getRealm(), user, updatedProfile);
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void close() {
    }

    public String getDisplayType() {
        return "Profile Validation";
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public FormAction create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

