/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.util.JsonSerialization;

public class RealmLocalizationResource {
    private final RealmModel realm;
    private final AdminPermissionEvaluator auth;
    @Context
    protected KeycloakSession session;

    public RealmLocalizationResource(RealmModel realm, AdminPermissionEvaluator auth) {
        this.realm = realm;
        this.auth = auth;
    }

    @Path(value="{locale}/{key}")
    @PUT
    @Consumes(value={"text/plain"})
    public void saveRealmLocalizationText(@PathParam(value="locale") String locale, @PathParam(value="key") String key, String text) {
        this.auth.realm().requireManageRealm();
        try {
            this.session.realms().saveLocalizationText(this.realm, locale, key, text);
        }
        catch (ModelDuplicateException e) {
            throw new BadRequestException(String.format("Localization text %s for the locale %s and realm %s already exists.", key, locale, this.realm.getId()));
        }
    }

    @POST
    @Path(value="{locale}")
    @Consumes(value={"multipart/form-data"})
    public void patchRealmLocalizationTextsFromFile(@PathParam(value="locale") String locale, MultipartFormDataInput input) throws IOException {
        this.auth.realm().requireManageRealm();
        Map formDataMap = input.getFormDataMap();
        if (!formDataMap.containsKey("file")) {
            throw new BadRequestException();
        }
        InputPart file = (InputPart)((List)formDataMap.get("file")).get(0);
        try (InputStream inputStream = (InputStream)file.getBody(InputStream.class, null);){
            TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
            Map rep = (Map)JsonSerialization.readValue((InputStream)inputStream, (TypeReference)typeRef);
            this.realm.patchRealmLocalizationTexts(locale, rep);
        }
        catch (IOException e) {
            throw new BadRequestException("Could not read file.");
        }
    }

    @PATCH
    @Path(value="{locale}")
    @Consumes(value={"application/json"})
    public void patchRealmLocalizationTexts(@PathParam(value="locale") String locale, Map<String, String> loclizationTexts) {
        this.auth.realm().requireManageRealm();
        this.realm.patchRealmLocalizationTexts(locale, loclizationTexts);
    }

    @Path(value="{locale}")
    @DELETE
    public void deleteRealmLocalizationTexts(@PathParam(value="locale") String locale) {
        this.auth.realm().requireManageRealm();
        if (!this.realm.removeRealmLocalizationTexts(locale)) {
            throw new NotFoundException("No localization texts for locale " + locale + " found.");
        }
    }

    @Path(value="{locale}/{key}")
    @DELETE
    public void deleteRealmLocalizationText(@PathParam(value="locale") String locale, @PathParam(value="key") String key) {
        this.auth.realm().requireManageRealm();
        if (!this.session.realms().deleteLocalizationText(this.realm, locale, key)) {
            throw new NotFoundException("Localization text not found");
        }
    }

    @GET
    @Produces(value={"application/json"})
    public List<String> getRealmLocalizationLocales() {
        this.auth.realm().requireViewRealm();
        ArrayList<String> realmLocalesList = new ArrayList<String>(this.realm.getRealmLocalizationTexts().keySet());
        Collections.sort(realmLocalesList);
        return realmLocalesList;
    }

    @Path(value="{locale}")
    @GET
    @Produces(value={"application/json"})
    public Map<String, String> getRealmLocalizationTexts(@PathParam(value="locale") String locale) {
        this.auth.realm().requireViewRealm();
        return this.realm.getRealmLocalizationTextsByLocale(locale);
    }

    @Path(value="{locale}/{key}")
    @GET
    @Produces(value={"text/plain"})
    public String getRealmLocalizationText(@PathParam(value="locale") String locale, @PathParam(value="key") String key) {
        this.auth.realm().requireViewRealm();
        String text = this.session.realms().getLocalizationTextsById(this.realm, locale, key);
        if (text != null) {
            return text;
        }
        throw new NotFoundException("Localization text not found");
    }
}

