/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.arc.BeanCreator;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.smallrye.config.SmallRyeConfig;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigBeanCreator
implements BeanCreator<Object> {
    public Object create(CreationalContext<Object> creationalContext, Map<String, Object> params) {
        Class<?> clazz;
        String requiredType = params.get("requiredType").toString();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ConfigBeanCreator.class.getClassLoader();
        }
        try {
            clazz = Class.forName(requiredType, true, cl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot load required type: " + requiredType);
        }
        InjectionPoint injectionPoint = InjectionPointProvider.get();
        if (injectionPoint == null) {
            throw new IllegalStateException("No current injection point found");
        }
        ConfigProperty configProperty = this.getConfigProperty(injectionPoint);
        if (configProperty == null) {
            throw new IllegalStateException("@ConfigProperty not found");
        }
        String key = configProperty.name();
        String defaultValue = configProperty.defaultValue();
        if (defaultValue.isEmpty() || "org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue)) {
            return this.getConfig().getValue(key, clazz);
        }
        Config config = this.getConfig();
        Optional value = config.getOptionalValue(key, clazz);
        if (value.isPresent()) {
            return value.get();
        }
        return ((SmallRyeConfig)config).convert(defaultValue, clazz);
    }

    private Config getConfig() {
        return ConfigProvider.getConfig();
    }

    private ConfigProperty getConfigProperty(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            return (ConfigProperty)qualifier;
        }
        return null;
    }
}

