/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.plugins.RxJavaPlugins;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.reactivex.impl.ObservableReadStream;
import io.vertx.reactivex.impl.ObservableUnmarshaller;
import io.vertx.reactivex.impl.ReadStreamSubscriber;
import java.util.function.Function;

public class ObservableHelper {
    public static <T> ReadStream<T> toReadStream(Observable<T> observable) {
        return ReadStreamSubscriber.asReadStream(observable, Function.identity());
    }

    public static <T> Observable<T> toObservable(ReadStream<T> stream) {
        return RxJavaPlugins.onAssembly(new ObservableReadStream(stream, Function.identity()));
    }

    public static <T, U> Observable<U> toObservable(ReadStream<T> stream, Function<T, U> mapping) {
        return RxJavaPlugins.onAssembly(new ObservableReadStream<T, U>(stream, mapping));
    }

    public static <T> ObservableTransformer<Buffer, T> unmarshaller(Class<T> mappedType) {
        return new ObservableUnmarshaller(Function.identity(), mappedType);
    }

    public static <T> ObservableTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef) {
        return new ObservableUnmarshaller(Function.identity(), mappedTypeRef);
    }

    public static <T> ObservableTransformer<Buffer, T> unmarshaller(Class<T> mappedType, ObjectMapper mapper) {
        return new ObservableUnmarshaller(Function.identity(), mappedType, mapper);
    }

    public static <T> ObservableTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef, ObjectMapper mapper) {
        return new ObservableUnmarshaller(Function.identity(), mappedTypeRef, mapper);
    }
}

