/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import io.reactivex.annotations.NonNull;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;

public class SingleUnmarshaller<T, B>
implements SingleTransformer<B, T> {
    private final Function<B, Buffer> unwrap;
    private final Class<T> mappedType;
    private final TypeReference<T> mappedTypeRef;
    private final ObjectMapper mapper;

    public SingleUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType) {
        this(unwrap, mappedType, null, Json.mapper);
    }

    public SingleUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef) {
        this(unwrap, null, mappedTypeRef, Json.mapper);
    }

    public SingleUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType, ObjectMapper mapper) {
        this(unwrap, mappedType, null, mapper);
    }

    public SingleUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef, ObjectMapper mapper) {
        this(unwrap, null, mappedTypeRef, mapper);
    }

    private SingleUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType, TypeReference<T> mappedTypeRef, ObjectMapper mapper) {
        this.unwrap = unwrap;
        this.mappedType = mappedType;
        this.mappedTypeRef = mappedTypeRef;
        this.mapper = mapper;
    }

    public SingleSource<T> apply(@NonNull Single<B> upstream) {
        Single unwrapped = upstream.map(this.unwrap::apply);
        Single unmarshalled = unwrapped.flatMap(buffer -> {
            try {
                Object obj = Objects.nonNull(this.mappedType) ? this.mapper.readValue(buffer.getBytes(), this.mappedType) : this.mapper.readValue(buffer.getBytes(), this.mappedTypeRef);
                return Single.just((Object)obj);
            }
            catch (IOException e) {
                return Single.error((Throwable)e);
            }
        });
        return unmarshalled;
    }
}

