/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.elementdesc.adapter.cdi.CDIBeanInfoAdapter;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import io.smallrye.metrics.interceptors.MetricResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.jboss.logging.Logger;

@Counted
@Interceptor
@Priority(value=1010)
public class CountedInterceptor {
    private static final Logger log = Logger.getLogger(CountedInterceptor.class);
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    CountedInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = new MetricResolver();
    }

    @AroundConstruct
    Object countedConstructor(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    Object countedMethod(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getMethod());
    }

    @AroundTimeout
    Object countedTimeout(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getMethod());
    }

    private <E extends Member & AnnotatedElement> Object countedCallable(InvocationContext context, E element) throws Exception {
        CDIBeanInfoAdapter beanInfoAdapter = new CDIBeanInfoAdapter();
        CDIMemberInfoAdapter<E> memberInfoAdapter = new CDIMemberInfoAdapter<E>();
        MetricResolver.Of<Counted> counted = this.resolver.counted(this.bean != null ? beanInfoAdapter.convert(this.bean.getBeanClass()) : beanInfoAdapter.convert(element.getDeclaringClass()), memberInfoAdapter.convert(element));
        String name = counted.metricName();
        Tag[] tags = counted.tags();
        MetricID metricID = new MetricID(name, tags);
        Counter counter = (Counter)this.registry.getCounters().get(metricID);
        if (counter == null) {
            throw new IllegalStateException("No counter with metricID [" + metricID + "] found in registry [" + this.registry + "]");
        }
        log.tracef("Increment counter [metricName: %s]", (Object)name);
        counter.inc();
        return context.proceed();
    }
}

