/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.profile;

import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.profile.representations.IdpUserProfile;
import org.keycloak.userprofile.profile.representations.UserModelUserProfile;
import org.keycloak.userprofile.profile.representations.UserRepresentationUserProfile;
import org.keycloak.userprofile.validation.UserUpdateEvent;

public class DefaultUserProfileContext
implements UserProfileContext {
    private UserProfile currentUserProfile;
    private UserUpdateEvent userUpdateEvent;

    private DefaultUserProfileContext(UserUpdateEvent userUpdateEvent, UserProfile currentUserProfile) {
        this.userUpdateEvent = userUpdateEvent;
        this.currentUserProfile = currentUserProfile;
    }

    public static DefaultUserProfileContext forIdpReview(SerializedBrokeredIdentityContext currentUser) {
        return new DefaultUserProfileContext(UserUpdateEvent.IdpReview, new IdpUserProfile(currentUser));
    }

    public static DefaultUserProfileContext forUpdateProfile(UserModel currentUser) {
        return new DefaultUserProfileContext(UserUpdateEvent.UpdateProfile, new UserModelUserProfile(currentUser));
    }

    public static DefaultUserProfileContext forAccountService(UserModel currentUser) {
        return new DefaultUserProfileContext(UserUpdateEvent.Account, new UserModelUserProfile(currentUser));
    }

    public static DefaultUserProfileContext forRegistrationUserCreation() {
        return new DefaultUserProfileContext(UserUpdateEvent.RegistrationUserCreation, null);
    }

    public static DefaultUserProfileContext forRegistrationProfile() {
        return new DefaultUserProfileContext(UserUpdateEvent.RegistrationProfile, null);
    }

    public static DefaultUserProfileContext forUserResource(UserRepresentation rep) {
        return new DefaultUserProfileContext(UserUpdateEvent.UserResource, new UserRepresentationUserProfile(rep));
    }

    public UserProfile getCurrentProfile() {
        return this.currentUserProfile;
    }

    public UserUpdateEvent getUpdateEvent() {
        return this.userUpdateEvent;
    }
}

