/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus;

import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValue;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import liquibase.logging.LogFactory;
import liquibase.servicelocator.ServiceLocator;
import org.jboss.logging.Logger;
import org.keycloak.QuarkusKeycloakSessionFactory;
import org.keycloak.cli.ShowConfigCommand;
import org.keycloak.common.Profile;
import org.keycloak.configuration.Configuration;
import org.keycloak.configuration.PropertyMappers;
import org.keycloak.connections.liquibase.FastServiceLocator;
import org.keycloak.connections.liquibase.KeycloakLogger;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.Spi;
import org.keycloak.util.Environment;

@Recorder
public class KeycloakRecorder {
    private static final Logger LOGGER = Logger.getLogger(KeycloakRecorder.class);

    public void configureLiquibase(Map<String, List<String>> services) {
        LogFactory.setInstance((LogFactory)new LogFactory(){
            final KeycloakLogger logger = new KeycloakLogger();

            public liquibase.logging.Logger getLog(String name) {
                return this.logger;
            }

            public liquibase.logging.Logger getLog() {
                return this.logger;
            }
        });
        System.setProperty("liquibase.scan.packages", "org.liquibase.core");
        ServiceLocator.setInstance((ServiceLocator)new FastServiceLocator(services));
    }

    public void configSessionFactory(Map<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories, Map<Class<? extends Provider>, String> defaultProviders, Boolean reaugmented) {
        Profile.setInstance((Profile)KeycloakRecorder.createProfile());
        QuarkusKeycloakSessionFactory.setInstance(new QuarkusKeycloakSessionFactory(factories, defaultProviders, reaugmented));
    }

    public void validateAndSetBuildTimeProperties(Boolean rebuild, String configArgs) {
        String configHelpText = configArgs;
        for (String propertyName : Configuration.getConfig().getPropertyNames()) {
            String prop;
            if (!this.shouldValidate(propertyName, rebuild)) continue;
            if (propertyName.startsWith("%")) {
                propertyName = propertyName.substring(propertyName.indexOf(46) + 1);
            }
            String buildValue = Environment.getBuiltTimeProperty(propertyName).orElse(null);
            ConfigValue value = Configuration.getConfig().getConfigValue(propertyName);
            if (value.getValue() == null || value.getValue().equalsIgnoreCase(buildValue) || configHelpText == null) continue;
            String cliNameFormat = PropertyMappers.toCLIFormat(propertyName);
            if (buildValue != null) {
                String currentProp = "--" + cliNameFormat.substring(3) + "=" + buildValue;
                String newProp = "--" + cliNameFormat.substring(3) + "=" + value.getValue();
                if (configHelpText.contains(currentProp)) {
                    LOGGER.warnf("The new value [%s] of the property [%s] in [%s] differs from the value [%s] set into the server image. The new value will override the value set into the server image.", new Object[]{value.getValue(), propertyName, value.getConfigSourceName(), buildValue});
                    configHelpText = configHelpText.replaceAll(currentProp, newProp);
                    continue;
                }
                if (configHelpText.contains("--" + cliNameFormat.substring(3))) continue;
                LOGGER.warnf("The new value [%s] of the property [%s] in [%s] differs from the value [%s] set into the server image. The new value will override the value set into the server image.", new Object[]{value.getValue(), propertyName, value.getConfigSourceName(), buildValue});
                configHelpText = configHelpText + " " + newProp;
                continue;
            }
            final String finalPropertyName = propertyName;
            if (StreamSupport.stream(Configuration.getConfig().getPropertyNames().spliterator(), false).filter(new Predicate<String>(){

                @Override
                public boolean test(String s) {
                    ConfigValue configValue = Configuration.getConfig().getConfigValue(s);
                    return configValue.getConfigSourceName().equals("PersistedConfigSource");
                }
            }).anyMatch(new Predicate<String>(){

                @Override
                public boolean test(String s) {
                    return PropertyMappers.canonicalFormat(finalPropertyName).equalsIgnoreCase(PropertyMappers.canonicalFormat(s));
                }
            }) || configHelpText.contains(prop = "--" + cliNameFormat.substring(3) + "=" + value.getValue())) continue;
            LOGGER.warnf("New property [%s] set with value [%s] in [%s]. This property is not persisted into the server image.", new Object[]{propertyName, value.getValue(), value.getConfigSourceName(), buildValue});
            configHelpText = configHelpText + " " + prop;
        }
        if (configArgs != null && !configArgs.equals(configHelpText)) {
            LOGGER.warnf("Please, run the 'config' command if you want to persist the new configuration into the server image:\n\n\t%s config %s\n", (Object)Environment.getCommand(), (Object)String.join((CharSequence)" ", configHelpText.split(",")));
        }
    }

    private boolean shouldValidate(String name, boolean rebuild) {
        return rebuild && name.contains("kc.") && !PropertyMappers.isBuildTimeProperty(name) && !"kc.version".equals(name) && !"kc.config.args".equals(name) && !"kc.home.dir".equals(name) && !"kc.config.file".equals(name) && !"kc.profile".equals(name) && !"kc.show.config".equals(name) && !"kc.show.config.runtime".equals(name) && !PropertyMappers.toCLIFormat("kc.config.file").equals(name);
    }

    public void showConfig() {
        ShowConfigCommand.run();
    }

    public static Profile createProfile() {
        return new Profile(new Profile.PropertyResolver(){

            public String resolve(String feature) {
                String value = Configuration.getBuiltTimeProperty(feature = feature.startsWith("keycloak.profile.feature") ? feature.replaceAll("keycloak\\.profile\\.feature", "kc\\.features") : "kc.features");
                if (value == null) {
                    value = Configuration.getBuiltTimeProperty(feature.replaceAll("\\.features\\.", "\\.features-"));
                }
                if (value != null) {
                    return value;
                }
                return Configuration.getRawValue(feature);
            }
        });
    }
}

