/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rx;

import io.vertx.lang.rx.RxGen;
import java.lang.reflect.Field;
import java.util.function.Function;

public class TypeArg<T> {
    private static TypeArg UNKNOWN = new TypeArg(Function.identity(), Function.identity());
    public final Function<Object, Object> wrap;
    public final Function<T, Object> unwrap;

    public static <U> TypeArg<U> of(Class<U> type) {
        RxGen rxgen = type.getAnnotation(RxGen.class);
        if (rxgen != null) {
            try {
                Field field = type.getField("__TYPE_ARG");
                return (TypeArg)field.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return TypeArg.unknown();
    }

    public static <T> TypeArg<T> unknown() {
        return UNKNOWN;
    }

    public TypeArg(Function<Object, Object> wrap, Function<T, Object> unwrap) {
        this.wrap = wrap;
        this.unwrap = unwrap;
    }

    public T wrap(Object o) {
        return (T)(o != null ? this.wrap.apply(o) : null);
    }

    public <X> X unwrap(T o) {
        return (X)(o != null ? this.unwrap.apply(o) : null);
    }
}

