/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Nationalized;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.FederatedIdentityEntity;
import org.keycloak.models.jpa.entities.UserAttributeEntity;
import org.keycloak.models.jpa.entities.UserRequiredActionEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

@NamedQueries(value={@NamedQuery(name="getAllUsersByRealm", query="select u from UserEntity u where u.realmId = :realmId order by u.username"), @NamedQuery(name="getAllUsersByRealmExcludeServiceAccount", query="select u from UserEntity u where u.realmId = :realmId and (u.serviceAccountClientLink is null) order by u.username"), @NamedQuery(name="searchForUserCount", query="select count(u) from UserEntity u where u.realmId = :realmId and (u.serviceAccountClientLink is null) and ( lower(u.username) like :search or lower(concat(coalesce(u.firstName, ''), ' ', coalesce(u.lastName, ''))) like :search or u.email like :search )"), @NamedQuery(name="getRealmUserByUsername", query="select u from UserEntity u where u.username = :username and u.realmId = :realmId"), @NamedQuery(name="getRealmUserByEmail", query="select u from UserEntity u where u.email = :email and u.realmId = :realmId"), @NamedQuery(name="getRealmUserByLastName", query="select u from UserEntity u where u.lastName = :lastName and u.realmId = :realmId"), @NamedQuery(name="getRealmUserByFirstLastName", query="select u from UserEntity u where u.firstName = :first and u.lastName = :last and u.realmId = :realmId"), @NamedQuery(name="getRealmUserByServiceAccount", query="select u from UserEntity u where u.serviceAccountClientLink = :clientInternalId and u.realmId = :realmId"), @NamedQuery(name="getRealmUserCount", query="select count(u) from UserEntity u where u.realmId = :realmId"), @NamedQuery(name="getRealmUserCountExcludeServiceAccount", query="select count(u) from UserEntity u where u.realmId = :realmId and (u.serviceAccountClientLink is null)"), @NamedQuery(name="getRealmUsersByAttributeNameAndValue", query="select u from UserEntity u join u.attributes attr where u.realmId = :realmId and attr.name = :name and attr.value = :value"), @NamedQuery(name="deleteUsersByRealm", query="delete from UserEntity u where u.realmId = :realmId"), @NamedQuery(name="deleteUsersByRealmAndLink", query="delete from UserEntity u where u.realmId = :realmId and u.federationLink=:link"), @NamedQuery(name="unlinkUsers", query="update UserEntity u set u.federationLink = null where u.realmId = :realmId and u.federationLink=:link")})
@Entity
@Table(name="USER_ENTITY", uniqueConstraints={@UniqueConstraint(columnNames={"REALM_ID", "USERNAME"}), @UniqueConstraint(columnNames={"REALM_ID", "EMAIL_CONSTRAINT"})})
public class UserEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    protected String id;
    @Nationalized
    @Column(name="USERNAME")
    protected String username;
    @Nationalized
    @Column(name="FIRST_NAME")
    protected String firstName;
    @Column(name="CREATED_TIMESTAMP")
    protected Long createdTimestamp;
    @Nationalized
    @Column(name="LAST_NAME")
    protected String lastName;
    @Column(name="EMAIL")
    protected String email;
    @Column(name="ENABLED")
    protected boolean enabled;
    @Column(name="EMAIL_VERIFIED")
    protected boolean emailVerified;
    @Column(name="EMAIL_CONSTRAINT")
    protected String emailConstraint;
    @Column(name="REALM_ID")
    protected String realmId;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="user")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected Collection<UserAttributeEntity> attributes;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="user")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected Collection<UserRequiredActionEntity> requiredActions;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="user")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected Collection<CredentialEntity> credentials;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="user")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected Collection<FederatedIdentityEntity> federatedIdentities;
    @Column(name="FEDERATION_LINK")
    protected String federationLink;
    @Column(name="SERVICE_ACCOUNT_CLIENT_LINK")
    protected String serviceAccountClientLink;
    @Column(name="NOT_BEFORE")
    protected int notBefore;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public UserEntity() {
        this.$$_hibernate_write_emailConstraint(KeycloakModelUtils.generateId());
    }

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getUsername() {
        return this.$$_hibernate_read_username();
    }

    public void setUsername(String username) {
        this.$$_hibernate_write_username(username);
    }

    public Long getCreatedTimestamp() {
        return this.$$_hibernate_read_createdTimestamp();
    }

    public void setCreatedTimestamp(Long timestamp) {
        this.$$_hibernate_write_createdTimestamp(timestamp);
    }

    public String getFirstName() {
        return this.$$_hibernate_read_firstName();
    }

    public void setFirstName(String firstName) {
        this.$$_hibernate_write_firstName(firstName);
    }

    public String getLastName() {
        return this.$$_hibernate_read_lastName();
    }

    public void setLastName(String lastName) {
        this.$$_hibernate_write_lastName(lastName);
    }

    public String getEmail() {
        return this.$$_hibernate_read_email();
    }

    public void setEmail(String email, boolean allowDuplicate) {
        this.$$_hibernate_write_email(email);
        this.$$_hibernate_write_emailConstraint(email == null || allowDuplicate ? KeycloakModelUtils.generateId() : email);
    }

    public boolean isEnabled() {
        return this.$$_hibernate_read_enabled();
    }

    public void setEnabled(boolean enabled) {
        this.$$_hibernate_write_enabled(enabled);
    }

    public String getEmailConstraint() {
        return this.$$_hibernate_read_emailConstraint();
    }

    public void setEmailConstraint(String emailConstraint) {
        this.$$_hibernate_write_emailConstraint(emailConstraint);
    }

    public boolean isEmailVerified() {
        return this.$$_hibernate_read_emailVerified();
    }

    public void setEmailVerified(boolean emailVerified) {
        this.$$_hibernate_write_emailVerified(emailVerified);
    }

    public Collection<UserAttributeEntity> getAttributes() {
        if (this.$$_hibernate_read_attributes() == null) {
            this.$$_hibernate_write_attributes(new LinkedList());
        }
        return this.$$_hibernate_read_attributes();
    }

    public void setAttributes(Collection<UserAttributeEntity> attributes) {
        this.$$_hibernate_write_attributes(attributes);
    }

    public Collection<UserRequiredActionEntity> getRequiredActions() {
        if (this.$$_hibernate_read_requiredActions() == null) {
            this.$$_hibernate_write_requiredActions(new LinkedList());
        }
        return this.$$_hibernate_read_requiredActions();
    }

    public void setRequiredActions(Collection<UserRequiredActionEntity> requiredActions) {
        this.$$_hibernate_write_requiredActions(requiredActions);
    }

    public String getRealmId() {
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_write_realmId(realmId);
    }

    public Collection<CredentialEntity> getCredentials() {
        if (this.$$_hibernate_read_credentials() == null) {
            this.$$_hibernate_write_credentials(new LinkedList());
        }
        return this.$$_hibernate_read_credentials();
    }

    public void setCredentials(Collection<CredentialEntity> credentials) {
        this.$$_hibernate_write_credentials(credentials);
    }

    public Collection<FederatedIdentityEntity> getFederatedIdentities() {
        if (this.$$_hibernate_read_federatedIdentities() == null) {
            this.$$_hibernate_write_federatedIdentities(new LinkedList());
        }
        return this.$$_hibernate_read_federatedIdentities();
    }

    public void setFederatedIdentities(Collection<FederatedIdentityEntity> federatedIdentities) {
        this.$$_hibernate_write_federatedIdentities(federatedIdentities);
    }

    public String getFederationLink() {
        return this.$$_hibernate_read_federationLink();
    }

    public void setFederationLink(String federationLink) {
        this.$$_hibernate_write_federationLink(federationLink);
    }

    public String getServiceAccountClientLink() {
        return this.$$_hibernate_read_serviceAccountClientLink();
    }

    public void setServiceAccountClientLink(String serviceAccountClientLink) {
        this.$$_hibernate_write_serviceAccountClientLink(serviceAccountClientLink);
    }

    public int getNotBefore() {
        return this.$$_hibernate_read_notBefore();
    }

    public void setNotBefore(int notBefore) {
        this.$$_hibernate_write_notBefore(notBefore);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof UserEntity)) {
            return false;
        }
        UserEntity that = (UserEntity)o;
        return this.$$_hibernate_read_id().equals(that.$$_hibernate_read_id());
    }

    public int hashCode() {
        return this.$$_hibernate_read_id().hashCode();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        UserEntity userEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        block0: {
            if (this.$$_hibernate_tracker == null) break block0;
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        UserEntity userEntity = this;
        userEntity = null;
        userEntity = NoopCollectionTracker.INSTANCE;
        return userEntity;
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_username() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.username = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "username", (Object)this.username);
        }
        return this.username;
    }

    public void $$_hibernate_write_username(String string) {
        if (!Objects.deepEquals(string, this.username)) {
            this.$$_hibernate_trackChange("username");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.username = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "username", (Object)this.username, (Object)string);
            return;
        }
        this.username = string;
    }

    public String $$_hibernate_read_firstName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.firstName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "firstName", (Object)this.firstName);
        }
        return this.firstName;
    }

    public void $$_hibernate_write_firstName(String string) {
        if (!Objects.deepEquals(string, this.firstName)) {
            this.$$_hibernate_trackChange("firstName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.firstName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "firstName", (Object)this.firstName, (Object)string);
            return;
        }
        this.firstName = string;
    }

    public Long $$_hibernate_read_createdTimestamp() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.createdTimestamp = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "createdTimestamp", (Object)this.createdTimestamp);
        }
        return this.createdTimestamp;
    }

    public void $$_hibernate_write_createdTimestamp(Long l) {
        if (!Objects.deepEquals(l, this.createdTimestamp)) {
            this.$$_hibernate_trackChange("createdTimestamp");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.createdTimestamp = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "createdTimestamp", (Object)this.createdTimestamp, (Object)l);
            return;
        }
        this.createdTimestamp = l;
    }

    public String $$_hibernate_read_lastName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastName", (Object)this.lastName);
        }
        return this.lastName;
    }

    public void $$_hibernate_write_lastName(String string) {
        if (!Objects.deepEquals(string, this.lastName)) {
            this.$$_hibernate_trackChange("lastName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastName", (Object)this.lastName, (Object)string);
            return;
        }
        this.lastName = string;
    }

    public String $$_hibernate_read_email() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.email = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "email", (Object)this.email);
        }
        return this.email;
    }

    public void $$_hibernate_write_email(String string) {
        if (!Objects.deepEquals(string, this.email)) {
            this.$$_hibernate_trackChange("email");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.email = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "email", (Object)this.email, (Object)string);
            return;
        }
        this.email = string;
    }

    public boolean $$_hibernate_read_enabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "enabled", this.enabled);
        }
        return this.enabled;
    }

    public void $$_hibernate_write_enabled(boolean bl) {
        if (bl - this.enabled != 0) {
            this.$$_hibernate_trackChange("enabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "enabled", this.enabled, bl);
            return;
        }
        this.enabled = bl;
    }

    public boolean $$_hibernate_read_emailVerified() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailVerified = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "emailVerified", this.emailVerified);
        }
        return this.emailVerified;
    }

    public void $$_hibernate_write_emailVerified(boolean bl) {
        if (bl - this.emailVerified != 0) {
            this.$$_hibernate_trackChange("emailVerified");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailVerified = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "emailVerified", this.emailVerified, bl);
            return;
        }
        this.emailVerified = bl;
    }

    public String $$_hibernate_read_emailConstraint() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailConstraint = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "emailConstraint", (Object)this.emailConstraint);
        }
        return this.emailConstraint;
    }

    public void $$_hibernate_write_emailConstraint(String string) {
        if (!Objects.deepEquals(string, this.emailConstraint)) {
            this.$$_hibernate_trackChange("emailConstraint");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailConstraint = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "emailConstraint", (Object)this.emailConstraint, (Object)string);
            return;
        }
        this.emailConstraint = string;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (!Objects.deepEquals(string, this.realmId)) {
            this.$$_hibernate_trackChange("realmId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public Collection $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }

    public void $$_hibernate_write_attributes(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "attributes", this.attributes, (Object)collection);
            return;
        }
        this.attributes = collection;
    }

    public Collection $$_hibernate_read_requiredActions() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requiredActions = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "requiredActions", this.requiredActions);
        }
        return this.requiredActions;
    }

    public void $$_hibernate_write_requiredActions(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requiredActions = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "requiredActions", this.requiredActions, (Object)collection);
            return;
        }
        this.requiredActions = collection;
    }

    public Collection $$_hibernate_read_credentials() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.credentials = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "credentials", this.credentials);
        }
        return this.credentials;
    }

    public void $$_hibernate_write_credentials(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.credentials = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "credentials", this.credentials, (Object)collection);
            return;
        }
        this.credentials = collection;
    }

    public Collection $$_hibernate_read_federatedIdentities() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.federatedIdentities = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "federatedIdentities", this.federatedIdentities);
        }
        return this.federatedIdentities;
    }

    public void $$_hibernate_write_federatedIdentities(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.federatedIdentities = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "federatedIdentities", this.federatedIdentities, (Object)collection);
            return;
        }
        this.federatedIdentities = collection;
    }

    public String $$_hibernate_read_federationLink() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.federationLink = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "federationLink", (Object)this.federationLink);
        }
        return this.federationLink;
    }

    public void $$_hibernate_write_federationLink(String string) {
        if (!Objects.deepEquals(string, this.federationLink)) {
            this.$$_hibernate_trackChange("federationLink");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.federationLink = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "federationLink", (Object)this.federationLink, (Object)string);
            return;
        }
        this.federationLink = string;
    }

    public String $$_hibernate_read_serviceAccountClientLink() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceAccountClientLink = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceAccountClientLink", (Object)this.serviceAccountClientLink);
        }
        return this.serviceAccountClientLink;
    }

    public void $$_hibernate_write_serviceAccountClientLink(String string) {
        if (!Objects.deepEquals(string, this.serviceAccountClientLink)) {
            this.$$_hibernate_trackChange("serviceAccountClientLink");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceAccountClientLink = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceAccountClientLink", (Object)this.serviceAccountClientLink, (Object)string);
            return;
        }
        this.serviceAccountClientLink = string;
    }

    public int $$_hibernate_read_notBefore() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notBefore = this.$$_hibernate_getInterceptor().readInt((Object)this, "notBefore", this.notBefore);
        }
        return this.notBefore;
    }

    public void $$_hibernate_write_notBefore(int n) {
        if (n - this.notBefore != 0) {
            this.$$_hibernate_trackChange("notBefore");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notBefore = this.$$_hibernate_getInterceptor().writeInt((Object)this, "notBefore", this.notBefore, n);
            return;
        }
        this.notBefore = n;
    }
}

