/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.anchor;

import com.webauthn4j.anchor.CachingTrustAnchorsProviderBase;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CertFileTrustAnchorsProvider
extends CachingTrustAnchorsProviderBase {
    private List<Path> certificates;

    public CertFileTrustAnchorsProvider() {
    }

    public CertFileTrustAnchorsProvider(List<Path> certificates) {
        this.certificates = certificates;
    }

    private void checkConfig() {
        AssertUtil.notNull(this.certificates, (String)"certificates must not be null");
    }

    @Override
    protected Map<AAGUID, Set<TrustAnchor>> loadTrustAnchors() {
        this.checkConfig();
        Set trustAnchors = this.certificates.stream().map(this::loadTrustAnchor).collect(Collectors.toSet());
        return Collections.singletonMap(AAGUID.NULL, trustAnchors);
    }

    private TrustAnchor loadTrustAnchor(Path certificate) {
        try {
            X509Certificate x509Certificate = CertificateUtil.generateX509Certificate((InputStream)Files.newInputStream(certificate, new OpenOption[0]));
            return new TrustAnchor(x509Certificate, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<Path> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(List<Path> certificates) {
        this.certificates = certificates;
    }
}

