/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.Arrays;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProviderFactory;
import org.keycloak.services.clientpolicy.condition.ClientUpdateSourceHostsCondition;

public class ClientUpdateSourceHostsConditionFactory
implements ClientPolicyConditionProviderFactory {
    public static final String PROVIDER_ID = "clientupdatesourcehost-condition";
    public static final String TRUSTED_HOSTS = "trusted-hosts";
    public static final String HOST_SENDING_REQUEST_MUST_MATCH = "host-sending-request-must-match";
    private static final ProviderConfigProperty TRUSTED_HOSTS_PROPERTY = new ProviderConfigProperty("trusted-hosts", "clientupdate-trusted-hosts.label", "clientupdate-trusted-hosts.tooltip", "MultivaluedString", null);
    private static final ProviderConfigProperty HOST_SENDING_REGISTRATION_REQUEST_MUST_MATCH_PROPERTY = new ProviderConfigProperty("host-sending-request-must-match", "host-sending-request-must-match.label", "host-sending-request-must-match.tooltip", "boolean", (Object)"true");

    public ClientPolicyConditionProvider create(KeycloakSession session, ComponentModel model) {
        return new ClientUpdateSourceHostsCondition(session, model);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "The condition checks the host/domain of the entity who tries to create/update the client to determine whether the policy is applied.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Arrays.asList(TRUSTED_HOSTS_PROPERTY, HOST_SENDING_REGISTRATION_REQUEST_MUST_MATCH_PROPERTY);
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)config).checkBoolean(HOST_SENDING_REGISTRATION_REQUEST_MUST_MATCH_PROPERTY, true);
        ClientUpdateSourceHostsCondition policy = new ClientUpdateSourceHostsCondition(session, config);
        if (!policy.isHostMustMatch()) {
            throw new ComponentValidationException("At least one of hosts verification must be enabled", new Object[0]);
        }
    }
}

