/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class UniOnNotNull<T> {
    private final Uni<T> upstream;

    public UniOnNotNull(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> invoke(Consumer<? super T> callback) {
        return this.upstream.onItem().invoke((? super T item) -> {
            if (item != null) {
                callback.accept(item);
            }
        });
    }

    public Uni<T> invoke(Runnable callback) {
        return this.upstream.onItem().invoke(callback);
    }

    @Deprecated
    public Uni<T> invokeUni(Function<? super T, Uni<?>> action) {
        return this.call(action);
    }

    public Uni<T> call(Function<? super T, Uni<?>> action) {
        return this.upstream.onItem().call((? super T item) -> {
            if (item != null) {
                return (Uni)action.apply(item);
            }
            return Uni.createFrom().nullItem();
        });
    }

    public Uni<T> call(Supplier<Uni<?>> action) {
        return this.upstream.onItem().call(action);
    }

    @Deprecated
    public <R> Uni<R> apply(Function<? super T, ? extends R> mapper) {
        return this.transform(mapper);
    }

    public <R> Uni<R> transform(Function<? super T, ? extends R> mapper) {
        return this.upstream.onItem().apply(item -> {
            if (item != null) {
                return mapper.apply(item);
            }
            return null;
        });
    }

    @Deprecated
    public <R> Uni<R> produceUni(Function<? super T, Uni<? extends R>> mapper) {
        return this.transformToUni(mapper);
    }

    public <R> Uni<R> transformToUni(Function<? super T, Uni<? extends R>> mapper) {
        return this.upstream.onItem().transformToUni((? super T item) -> {
            if (item != null) {
                return (Uni)mapper.apply(item);
            }
            return Uni.createFrom().nullItem();
        });
    }

    public <R> Multi<R> transformToMulti(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.upstream.onItem().transformToMulti(item -> {
            if (item != null) {
                return (Publisher)mapper.apply(item);
            }
            return Multi.createFrom().empty();
        });
    }

    @Deprecated
    public <R> Multi<R> produceMulti(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.transformToMulti(mapper);
    }

    @Deprecated
    public <R> Uni<R> produceCompletionStage(Function<? super T, ? extends CompletionStage<? extends R>> mapper) {
        return this.upstream.onItem().transformToUni((? super T item) -> {
            if (item != null) {
                return Uni.createFrom().completionStage((CompletionStage)mapper.apply(item));
            }
            return Uni.createFrom().nullItem();
        });
    }

    public <R> Uni<R> transformToUni(BiConsumer<? super T, UniEmitter<? super R>> consumer) {
        return this.upstream.onItem().transformToUni((? super T item, UniEmitter<? super R> emitter) -> {
            if (item != null) {
                consumer.accept((Object)item, (UniEmitter)emitter);
            } else {
                emitter.complete(null);
            }
        });
    }

    @Deprecated
    public <R> Uni<R> produceUni(BiConsumer<? super T, UniEmitter<? super R>> consumer) {
        return this.transformToUni(consumer);
    }
}

