/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class ClientUpdateSourceHostsCondition
implements ClientPolicyConditionProvider {
    private static final Logger logger = Logger.getLogger(ClientUpdateSourceHostsCondition.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public ClientUpdateSourceHostsCondition(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: {
                if (!this.isHostMustMatch()) {
                    return ClientPolicyVote.ABSTAIN;
                }
                if (this.isHostMatched()) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private boolean isHostMatched() {
        String hostAddress = this.session.getContext().getConnection().getRemoteAddr();
        ClientPolicyLogger.logv(logger, "Verifying remote host {0}", hostAddress);
        List<String> trustedHosts = this.getTrustedHosts();
        List<String> trustedDomains = this.getTrustedDomains();
        String verifiedHost = this.verifyHostInTrustedHosts(hostAddress, trustedHosts);
        if (verifiedHost != null) {
            return true;
        }
        verifiedHost = this.verifyHostInTrustedDomains(hostAddress, trustedDomains);
        return verifiedHost != null;
    }

    protected List<String> getTrustedHosts() {
        List trustedHostsConfig = this.componentModel.getConfig().getList((Object)"trusted-hosts");
        return trustedHostsConfig.stream().filter(hostname -> !hostname.startsWith("*.")).collect(Collectors.toList());
    }

    protected List<String> getTrustedDomains() {
        List trustedHostsConfig = this.componentModel.getConfig().getList((Object)"trusted-hosts");
        LinkedList<String> domains = new LinkedList<String>();
        for (String hostname : trustedHostsConfig) {
            if (!hostname.startsWith("*.")) continue;
            hostname = hostname.substring(2);
            domains.add(hostname);
        }
        return domains;
    }

    protected String verifyHostInTrustedHosts(String hostAddress, List<String> trustedHosts) {
        for (String confHostName : trustedHosts) {
            try {
                String hostIPAddress = InetAddress.getByName(confHostName).getHostAddress();
                ClientPolicyLogger.logv(logger, "Trying host {0} of address {1}", confHostName, hostIPAddress);
                if (!hostIPAddress.equals(hostAddress)) continue;
                ClientPolicyLogger.logv(logger, "Successfully verified host : {0}", confHostName);
                return confHostName;
            }
            catch (UnknownHostException uhe) {
                ClientPolicyLogger.logv(logger, "Unknown host from realm configuration: {0}", confHostName);
            }
        }
        return null;
    }

    protected String verifyHostInTrustedDomains(String hostAddress, List<String> trustedDomains) {
        if (!trustedDomains.isEmpty()) {
            try {
                String hostname = InetAddress.getByName(hostAddress).getHostName();
                ClientPolicyLogger.logv(logger, "Trying verify request from address {0} of host {1} by domains", hostAddress, hostname);
                for (String confDomain : trustedDomains) {
                    if (!hostname.endsWith(confDomain)) continue;
                    ClientPolicyLogger.logv(logger, "Successfully verified host {0} by trusted domain {1}", hostname, confDomain);
                    return hostname;
                }
            }
            catch (UnknownHostException uhe) {
                ClientPolicyLogger.logv(logger, "Request of address {0} came from unknown host. Skip verification by domains", hostAddress);
            }
        }
        return null;
    }

    boolean isHostMustMatch() {
        return this.parseBoolean("host-sending-request-must-match");
    }

    private boolean parseBoolean(String propertyKey) {
        String val = (String)this.componentModel.getConfig().getFirst((Object)propertyKey);
        return val == null || Boolean.parseBoolean(val);
    }
}

