/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.Objects;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.policy.PasswordPolicyNotMetException;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.utils.StreamsUtil;

public class RealmsAdminResource {
    protected static final Logger logger = Logger.getLogger(RealmsAdminResource.class);
    protected AdminAuth auth;
    protected TokenManager tokenManager;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;
    public static final CacheControl noCache = new CacheControl();

    public RealmsAdminResource(AdminAuth auth, TokenManager tokenManager) {
        this.auth = auth;
        this.tokenManager = tokenManager;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<RealmRepresentation> getRealms() {
        Stream<RealmRepresentation> realms = this.session.realms().getRealmsStream().map(this::toRealmRep).filter(Objects::nonNull);
        return StreamsUtil.throwIfEmpty(realms, (RuntimeException)((Object)new ForbiddenException()));
    }

    protected RealmRepresentation toRealmRep(RealmModel realm) {
        if (AdminPermissions.realms(this.session, this.auth).canView(realm)) {
            return ModelToRepresentation.toRepresentation((RealmModel)realm, (boolean)false);
        }
        if (AdminPermissions.realms(this.session, this.auth).isAdmin(realm)) {
            RealmRepresentation rep = new RealmRepresentation();
            rep.setRealm(realm.getName());
            return rep;
        }
        return null;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response importRealm(RealmRepresentation rep) {
        RealmManager realmManager = new RealmManager(this.session);
        AdminPermissions.realms(this.session, this.auth).requireCreateRealm();
        logger.debugv("importRealm: {0}", (Object)rep.getRealm());
        try {
            RealmModel realm = realmManager.importRealm(rep);
            this.grantPermissionsToRealmCreator(realm);
            URI location = AdminRoot.realmsUrl((UriInfo)this.session.getContext().getUri()).path(realm.getName()).build(new Object[0]);
            logger.debugv("imported realm success, sending back: {0}", (Object)location.toString());
            return Response.created((URI)location).build();
        }
        catch (ModelDuplicateException e) {
            logger.error((Object)"Conflict detected", (Throwable)e);
            return ErrorResponse.exists("Conflict detected. See logs for details");
        }
        catch (PasswordPolicyNotMetException e) {
            logger.error((Object)("Password policy not met for user " + e.getUsername()), (Throwable)e);
            if (this.session.getTransactionManager().isActive()) {
                this.session.getTransactionManager().setRollbackOnly();
            }
            return ErrorResponse.error("Password policy not met. See logs for details", Response.Status.BAD_REQUEST);
        }
    }

    private void grantPermissionsToRealmCreator(RealmModel realm) {
        if (this.auth.hasRealmRole(AdminRoles.ADMIN)) {
            return;
        }
        RealmModel adminRealm = new RealmManager(this.session).getKeycloakAdminstrationRealm();
        ClientModel realmAdminApp = realm.getMasterAdminClient();
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel role = realmAdminApp.getRole(r);
            this.auth.getUser().grantRole(role);
        }
    }

    @Path(value="{realm}")
    public RealmAdminResource getRealmAdmin(@Context HttpHeaders headers, @PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(name);
        if (realm == null) {
            throw new NotFoundException("Realm not found.");
        }
        if (!this.auth.getRealm().equals(realmManager.getKeycloakAdminstrationRealm()) && !this.auth.getRealm().equals(realm)) {
            throw new ForbiddenException();
        }
        AdminPermissionEvaluator realmAuth = AdminPermissions.evaluator(this.session, realm, this.auth);
        AdminEventBuilder adminEvent = new AdminEventBuilder(realm, this.auth, this.session, this.clientConnection);
        this.session.getContext().setRealm(realm);
        RealmAdminResource adminResource = new RealmAdminResource(realmAuth, realm, this.tokenManager, adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)adminResource);
        return adminResource;
    }

    static {
        noCache.setNoCache(true);
    }
}

