/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.entities;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.entities.ResourceAttributeEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;

@Entity
@Table(name="RESOURCE_SERVER_RESOURCE", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "RESOURCE_SERVER_ID", "OWNER"})})
@NamedQueries(value={@NamedQuery(name="findResourceIdByOwner", query="select r from ResourceEntity r  where r.resourceServer = :serverId and r.owner = :owner"), @NamedQuery(name="findResourceIdByOwnerOrdered", query="select r from ResourceEntity r where r.resourceServer = :serverId and r.owner = :owner order by r.id"), @NamedQuery(name="findAnyResourceIdByOwner", query="select r from ResourceEntity r where r.owner = :owner"), @NamedQuery(name="findAnyResourceIdByOwnerOrdered", query="select r.id from ResourceEntity r where r.owner = :owner order by r.id"), @NamedQuery(name="findResourceIdByUri", query="select r.id from ResourceEntity r where  r.resourceServer = :serverId  and :uri in elements(r.uris)"), @NamedQuery(name="findResourceIdByName", query="select r from ResourceEntity r left join fetch r.scopes s where  r.resourceServer = :serverId  and r.owner = :ownerId and r.name = :name"), @NamedQuery(name="findResourceIdByType", query="select r from ResourceEntity r left join fetch r.scopes s where  r.resourceServer = :serverId  and r.owner = :ownerId and r.type = :type"), @NamedQuery(name="findResourceIdByTypeNoOwner", query="select r from ResourceEntity r left join fetch r.scopes s where  r.resourceServer = :serverId  and r.type = :type"), @NamedQuery(name="findResourceIdByTypeInstance", query="select r from ResourceEntity r left join fetch r.scopes s where  r.resourceServer = :serverId and r.type = :type and r.owner <> :serverId"), @NamedQuery(name="findResourceIdByServerId", query="select r.id from ResourceEntity r where  r.resourceServer = :serverId "), @NamedQuery(name="findResourceIdByScope", query="select r from ResourceEntity r inner join r.scopes s where r.resourceServer = :serverId and (s.resourceServer = :serverId and s.id in (:scopeIds))"), @NamedQuery(name="deleteResourceByResourceServer", query="delete from ResourceEntity r where r.resourceServer = :serverId")})
public class ResourceEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    private String id;
    @Column(name="NAME")
    private String name;
    @Column(name="DISPLAY_NAME")
    private String displayName;
    @ElementCollection(fetch=FetchType.LAZY)
    @Column(name="VALUE")
    @CollectionTable(name="RESOURCE_URIS", joinColumns={@JoinColumn(name="RESOURCE_ID")})
    private Set<String> uris;
    @Column(name="TYPE")
    private String type;
    @Column(name="ICON_URI")
    private String iconUri;
    @Column(name="OWNER")
    private String owner;
    @Column(name="OWNER_MANAGED_ACCESS")
    private boolean ownerManagedAccess;
    @Column(name="RESOURCE_SERVER_ID")
    private String resourceServer;
    @OneToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="RESOURCE_SCOPE", joinColumns={@JoinColumn(name="RESOURCE_ID")}, inverseJoinColumns={@JoinColumn(name="SCOPE_ID")})
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    private List<ScopeEntity> scopes;
    @ManyToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="RESOURCE_POLICY", joinColumns={@JoinColumn(name="RESOURCE_ID")}, inverseJoinColumns={@JoinColumn(name="POLICY_ID")})
    private List<PolicyEntity> policies;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="resource", fetch=FetchType.LAZY)
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    private Collection<ResourceAttributeEntity> attributes;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public String getDisplayName() {
        return this.$$_hibernate_read_displayName();
    }

    public void setDisplayName(String displayName) {
        this.$$_hibernate_write_displayName(displayName);
    }

    public Set<String> getUris() {
        if (this.$$_hibernate_read_uris() == null) {
            this.$$_hibernate_write_uris(new HashSet());
        }
        return this.$$_hibernate_read_uris();
    }

    public void setUris(Set<String> uris) {
        this.$$_hibernate_write_uris(uris);
    }

    public String getType() {
        return this.$$_hibernate_read_type();
    }

    public void setType(String type) {
        this.$$_hibernate_write_type(type);
    }

    public List<ScopeEntity> getScopes() {
        if (this.$$_hibernate_read_scopes() == null) {
            this.$$_hibernate_write_scopes(new LinkedList());
        }
        return this.$$_hibernate_read_scopes();
    }

    public String getIconUri() {
        return this.$$_hibernate_read_iconUri();
    }

    public void setIconUri(String iconUri) {
        this.$$_hibernate_write_iconUri(iconUri);
    }

    public String getResourceServer() {
        return this.$$_hibernate_read_resourceServer();
    }

    public void setResourceServer(String resourceServer) {
        this.$$_hibernate_write_resourceServer(resourceServer);
    }

    public String getOwner() {
        return this.$$_hibernate_read_owner();
    }

    public void setOwner(String owner) {
        this.$$_hibernate_write_owner(owner);
    }

    public void setOwnerManagedAccess(boolean ownerManagedAccess) {
        this.$$_hibernate_write_ownerManagedAccess(ownerManagedAccess);
    }

    public boolean isOwnerManagedAccess() {
        return this.$$_hibernate_read_ownerManagedAccess();
    }

    public List<PolicyEntity> getPolicies() {
        if (this.$$_hibernate_read_policies() == null) {
            this.$$_hibernate_write_policies(new LinkedList());
        }
        return this.$$_hibernate_read_policies();
    }

    public void setPolicies(List<PolicyEntity> policies) {
        this.$$_hibernate_write_policies(policies);
    }

    public Collection<ResourceAttributeEntity> getAttributes() {
        if (this.$$_hibernate_read_attributes() == null) {
            this.$$_hibernate_write_attributes(new LinkedList());
        }
        return this.$$_hibernate_read_attributes();
    }

    public void setAttributes(Collection<ResourceAttributeEntity> attributes) {
        this.$$_hibernate_write_attributes(attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceEntity that = (ResourceEntity)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        ResourceEntity resourceEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        block0: {
            if (this.$$_hibernate_tracker == null) break block0;
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        ResourceEntity resourceEntity = this;
        resourceEntity = null;
        resourceEntity = NoopCollectionTracker.INSTANCE;
        return resourceEntity;
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!Objects.deepEquals(string, this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_displayName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.displayName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "displayName", (Object)this.displayName);
        }
        return this.displayName;
    }

    public void $$_hibernate_write_displayName(String string) {
        if (!Objects.deepEquals(string, this.displayName)) {
            this.$$_hibernate_trackChange("displayName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.displayName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "displayName", (Object)this.displayName, (Object)string);
            return;
        }
        this.displayName = string;
    }

    public Set $$_hibernate_read_uris() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.uris = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "uris", this.uris);
        }
        return this.uris;
    }

    public void $$_hibernate_write_uris(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.uris = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "uris", this.uris, (Object)set);
            return;
        }
        this.uris = set;
    }

    public String $$_hibernate_read_type() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.type = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "type", (Object)this.type);
        }
        return this.type;
    }

    public void $$_hibernate_write_type(String string) {
        if (!Objects.deepEquals(string, this.type)) {
            this.$$_hibernate_trackChange("type");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.type = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "type", (Object)this.type, (Object)string);
            return;
        }
        this.type = string;
    }

    public String $$_hibernate_read_iconUri() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.iconUri = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "iconUri", (Object)this.iconUri);
        }
        return this.iconUri;
    }

    public void $$_hibernate_write_iconUri(String string) {
        if (!Objects.deepEquals(string, this.iconUri)) {
            this.$$_hibernate_trackChange("iconUri");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.iconUri = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "iconUri", (Object)this.iconUri, (Object)string);
            return;
        }
        this.iconUri = string;
    }

    public String $$_hibernate_read_owner() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "owner", (Object)this.owner);
        }
        return this.owner;
    }

    public void $$_hibernate_write_owner(String string) {
        if (!Objects.deepEquals(string, this.owner)) {
            this.$$_hibernate_trackChange("owner");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "owner", (Object)this.owner, (Object)string);
            return;
        }
        this.owner = string;
    }

    public boolean $$_hibernate_read_ownerManagedAccess() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ownerManagedAccess = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "ownerManagedAccess", this.ownerManagedAccess);
        }
        return this.ownerManagedAccess;
    }

    public void $$_hibernate_write_ownerManagedAccess(boolean bl) {
        if (bl - this.ownerManagedAccess != 0) {
            this.$$_hibernate_trackChange("ownerManagedAccess");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ownerManagedAccess = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "ownerManagedAccess", this.ownerManagedAccess, bl);
            return;
        }
        this.ownerManagedAccess = bl;
    }

    public String $$_hibernate_read_resourceServer() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServer = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "resourceServer", (Object)this.resourceServer);
        }
        return this.resourceServer;
    }

    public void $$_hibernate_write_resourceServer(String string) {
        if (!Objects.deepEquals(string, this.resourceServer)) {
            this.$$_hibernate_trackChange("resourceServer");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServer = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resourceServer", (Object)this.resourceServer, (Object)string);
            return;
        }
        this.resourceServer = string;
    }

    public List $$_hibernate_read_scopes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopes = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "scopes", this.scopes);
        }
        return this.scopes;
    }

    public void $$_hibernate_write_scopes(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopes = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "scopes", this.scopes, (Object)list);
            return;
        }
        this.scopes = list;
    }

    public List $$_hibernate_read_policies() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.policies = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "policies", this.policies);
        }
        return this.policies;
    }

    public void $$_hibernate_write_policies(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.policies = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "policies", this.policies, (Object)list);
            return;
        }
        this.policies = list;
    }

    public Collection $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }

    public void $$_hibernate_write_attributes(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "attributes", this.attributes, (Object)collection);
            return;
        }
        this.attributes = collection;
    }
}

