/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.resolver.QuarkusModelBuildAction;
import io.quarkus.bootstrap.resolver.model.QuarkusModel;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;

public class QuarkusGradleModelFactory {
    public static QuarkusModel create(File projectDir, String mode, String ... tasks) {
        return QuarkusGradleModelFactory.create(projectDir, mode, Collections.emptyList(), tasks);
    }

    public static QuarkusModel create(File projectDir, String mode, List<String> jvmArgs, String ... tasks) {
        try (ProjectConnection connection = GradleConnector.newConnector().forProjectDirectory(projectDir).connect();){
            ((BuildLauncher)connection.newBuild().forTasks(tasks).addJvmArguments(jvmArgs)).run();
            QuarkusModel quarkusModel = connection.action(new QuarkusModelBuildAction(mode)).run();
            return quarkusModel;
        }
    }

    public static QuarkusModel createForTasks(File projectDir, String ... tasks) {
        try (ProjectConnection connection = GradleConnector.newConnector().forProjectDirectory(projectDir).connect();){
            ModelBuilder<QuarkusModel> modelBuilder = connection.model(QuarkusModel.class);
            modelBuilder.forTasks(tasks);
            QuarkusModel quarkusModel = modelBuilder.get();
            return quarkusModel;
        }
    }
}

