/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.entities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Nationalized;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

@Entity
@Table(name="RESOURCE_SERVER_POLICY", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "RESOURCE_SERVER_ID"})})
@NamedQueries(value={@NamedQuery(name="findPolicyIdByServerId", query="select p.id from PolicyEntity p where  p.resourceServer.id = :serverId "), @NamedQuery(name="findPolicyIdByName", query="select p from PolicyEntity p left join fetch p.associatedPolicies a where  p.resourceServer.id = :serverId  and p.name = :name"), @NamedQuery(name="findPolicyIdByResource", query="select p from PolicyEntity p inner join p.resources r where p.resourceServer.id = :serverId and (r.resourceServer = :serverId and r.id = :resourceId)"), @NamedQuery(name="findPolicyIdByScope", query="select pe from PolicyEntity pe inner join pe.scopes s where pe.type = 'scope' and pe.resourceServer.id = :serverId and s.id in (:scopeIds)"), @NamedQuery(name="findPolicyIdByResourceScope", query="select pe from PolicyEntity pe inner join pe.resources r inner join pe.scopes s where pe.resourceServer.id = :serverId and pe.type = 'scope' and s.id in (:scopeIds) and r.id in (:resourceId)"), @NamedQuery(name="findPolicyIdByNullResourceScope", query="select pe from PolicyEntity pe left join fetch pe.config c inner join pe.scopes s  where pe.resourceServer.id = :serverId and pe.type = 'scope' and pe.resources is empty and s.id in (:scopeIds) and not exists (select pec from pe.config pec where KEY(pec) = 'defaultResourceType')"), @NamedQuery(name="findPolicyIdByType", query="select p.id from PolicyEntity p where p.resourceServer.id = :serverId and p.type = :type"), @NamedQuery(name="findPolicyIdByResourceType", query="select p from PolicyEntity p inner join p.config c inner join fetch p.associatedPolicies a where p.resourceServer.id = :serverId and KEY(c) = 'defaultResourceType' and c like :type"), @NamedQuery(name="findPolicyIdByDependentPolices", query="select p.id from PolicyEntity p inner join p.associatedPolicies ap where p.resourceServer.id = :serverId and (ap.resourceServer.id = :serverId and ap.id = :policyId)"), @NamedQuery(name="deletePolicyByResourceServer", query="delete from PolicyEntity p where p.resourceServer.id = :serverId")})
public class PolicyEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    private String id;
    @Column(name="NAME")
    private String name;
    @Nationalized
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="TYPE")
    private String type;
    @Column(name="DECISION_STRATEGY")
    private DecisionStrategy decisionStrategy;
    @Column(name="LOGIC")
    private Logic logic;
    @ElementCollection(fetch=FetchType.LAZY)
    @MapKeyColumn(name="NAME")
    @Column(name="VALUE", columnDefinition="TEXT")
    @CollectionTable(name="POLICY_CONFIG", joinColumns={@JoinColumn(name="POLICY_ID")})
    private Map<String, String> config;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="RESOURCE_SERVER_ID")
    private ResourceServerEntity resourceServer;
    @OneToMany(fetch=FetchType.EAGER, cascade={})
    @JoinTable(name="ASSOCIATED_POLICY", joinColumns={@JoinColumn(name="POLICY_ID")}, inverseJoinColumns={@JoinColumn(name="ASSOCIATED_POLICY_ID")})
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    private Set<PolicyEntity> associatedPolicies;
    @OneToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="RESOURCE_POLICY", joinColumns={@JoinColumn(name="POLICY_ID")}, inverseJoinColumns={@JoinColumn(name="RESOURCE_ID")})
    private Set<ResourceEntity> resources;
    @OneToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="SCOPE_POLICY", joinColumns={@JoinColumn(name="POLICY_ID")}, inverseJoinColumns={@JoinColumn(name="SCOPE_ID")})
    private Set<ScopeEntity> scopes;
    @Column(name="OWNER")
    private String owner;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public PolicyEntity() {
        this.$$_hibernate_write_decisionStrategy(DecisionStrategy.UNANIMOUS);
        this.$$_hibernate_write_logic(Logic.POSITIVE);
    }

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getType() {
        return this.$$_hibernate_read_type();
    }

    public void setType(String type) {
        this.$$_hibernate_write_type(type);
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.$$_hibernate_read_decisionStrategy();
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.$$_hibernate_write_decisionStrategy(decisionStrategy);
    }

    public Logic getLogic() {
        return this.$$_hibernate_read_logic();
    }

    public void setLogic(Logic logic) {
        this.$$_hibernate_write_logic(logic);
    }

    public Map<String, String> getConfig() {
        if (this.$$_hibernate_read_config() == null) {
            this.$$_hibernate_write_config(new HashMap());
        }
        return this.$$_hibernate_read_config();
    }

    public void setConfig(Map<String, String> config) {
        this.$$_hibernate_write_config(config);
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public String getDescription() {
        return this.$$_hibernate_read_description();
    }

    public void setDescription(String description) {
        this.$$_hibernate_write_description(description);
    }

    public ResourceServerEntity getResourceServer() {
        return this.$$_hibernate_read_resourceServer();
    }

    public void setResourceServer(ResourceServerEntity resourceServer) {
        this.$$_hibernate_write_resourceServer(resourceServer);
    }

    public Set<ResourceEntity> getResources() {
        if (this.$$_hibernate_read_resources() == null) {
            this.$$_hibernate_write_resources(new HashSet());
        }
        return this.$$_hibernate_read_resources();
    }

    public void setResources(Set<ResourceEntity> resources) {
        this.$$_hibernate_write_resources(resources);
    }

    public Set<ScopeEntity> getScopes() {
        if (this.$$_hibernate_read_scopes() == null) {
            this.$$_hibernate_write_scopes(new HashSet());
        }
        return this.$$_hibernate_read_scopes();
    }

    public void setScopes(Set<ScopeEntity> scopes) {
        this.$$_hibernate_write_scopes(scopes);
    }

    public Set<PolicyEntity> getAssociatedPolicies() {
        if (this.$$_hibernate_read_associatedPolicies() == null) {
            this.$$_hibernate_write_associatedPolicies(new HashSet());
        }
        return this.$$_hibernate_read_associatedPolicies();
    }

    public void setAssociatedPolicies(Set<PolicyEntity> associatedPolicies) {
        this.$$_hibernate_write_associatedPolicies(associatedPolicies);
    }

    public String getOwner() {
        return this.$$_hibernate_read_owner();
    }

    public void setOwner(String owner) {
        this.$$_hibernate_write_owner(owner);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyEntity that = (PolicyEntity)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        PolicyEntity policyEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        block0: {
            if (this.$$_hibernate_tracker == null) break block0;
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        PolicyEntity policyEntity = this;
        policyEntity = null;
        policyEntity = NoopCollectionTracker.INSTANCE;
        return policyEntity;
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!Objects.deepEquals(string, this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_description() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "description", (Object)this.description);
        }
        return this.description;
    }

    public void $$_hibernate_write_description(String string) {
        if (!Objects.deepEquals(string, this.description)) {
            this.$$_hibernate_trackChange("description");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "description", (Object)this.description, (Object)string);
            return;
        }
        this.description = string;
    }

    public String $$_hibernate_read_type() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.type = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "type", (Object)this.type);
        }
        return this.type;
    }

    public void $$_hibernate_write_type(String string) {
        if (!Objects.deepEquals(string, this.type)) {
            this.$$_hibernate_trackChange("type");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.type = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "type", (Object)this.type, (Object)string);
            return;
        }
        this.type = string;
    }

    public DecisionStrategy $$_hibernate_read_decisionStrategy() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.decisionStrategy = (DecisionStrategy)this.$$_hibernate_getInterceptor().readObject((Object)this, "decisionStrategy", (Object)this.decisionStrategy);
        }
        return this.decisionStrategy;
    }

    public void $$_hibernate_write_decisionStrategy(DecisionStrategy decisionStrategy) {
        if (!Objects.deepEquals(decisionStrategy, this.decisionStrategy)) {
            this.$$_hibernate_trackChange("decisionStrategy");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.decisionStrategy = (DecisionStrategy)this.$$_hibernate_getInterceptor().writeObject((Object)this, "decisionStrategy", (Object)this.decisionStrategy, (Object)decisionStrategy);
            return;
        }
        this.decisionStrategy = decisionStrategy;
    }

    public Logic $$_hibernate_read_logic() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.logic = (Logic)this.$$_hibernate_getInterceptor().readObject((Object)this, "logic", (Object)this.logic);
        }
        return this.logic;
    }

    public void $$_hibernate_write_logic(Logic logic) {
        if (!Objects.deepEquals(logic, this.logic)) {
            this.$$_hibernate_trackChange("logic");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.logic = (Logic)this.$$_hibernate_getInterceptor().writeObject((Object)this, "logic", (Object)this.logic, (Object)logic);
            return;
        }
        this.logic = logic;
    }

    public Map $$_hibernate_read_config() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.config = (Map)this.$$_hibernate_getInterceptor().readObject((Object)this, "config", this.config);
        }
        return this.config;
    }

    public void $$_hibernate_write_config(Map map) {
        if (!Objects.deepEquals(map, this.config)) {
            this.$$_hibernate_trackChange("config");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.config = (Map)this.$$_hibernate_getInterceptor().writeObject((Object)this, "config", this.config, (Object)map);
            return;
        }
        this.config = map;
    }

    public ResourceServerEntity $$_hibernate_read_resourceServer() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServer = (ResourceServerEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "resourceServer", (Object)this.resourceServer);
        }
        return this.resourceServer;
    }

    public void $$_hibernate_write_resourceServer(ResourceServerEntity resourceServerEntity) {
        if (!Objects.deepEquals(resourceServerEntity, this.resourceServer)) {
            this.$$_hibernate_trackChange("resourceServer");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resourceServer = (ResourceServerEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resourceServer", (Object)this.resourceServer, (Object)resourceServerEntity);
            return;
        }
        this.resourceServer = resourceServerEntity;
    }

    public Set $$_hibernate_read_associatedPolicies() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.associatedPolicies = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "associatedPolicies", this.associatedPolicies);
        }
        return this.associatedPolicies;
    }

    public void $$_hibernate_write_associatedPolicies(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.associatedPolicies = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "associatedPolicies", this.associatedPolicies, (Object)set);
            return;
        }
        this.associatedPolicies = set;
    }

    public Set $$_hibernate_read_resources() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resources = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "resources", this.resources);
        }
        return this.resources;
    }

    public void $$_hibernate_write_resources(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resources = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resources", this.resources, (Object)set);
            return;
        }
        this.resources = set;
    }

    public Set $$_hibernate_read_scopes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopes = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "scopes", this.scopes);
        }
        return this.scopes;
    }

    public void $$_hibernate_write_scopes(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.scopes = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "scopes", this.scopes, (Object)set);
            return;
        }
        this.scopes = set;
    }

    public String $$_hibernate_read_owner() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "owner", (Object)this.owner);
        }
        return this.owner;
    }

    public void $$_hibernate_write_owner(String string) {
        if (!Objects.deepEquals(string, this.owner)) {
            this.$$_hibernate_trackChange("owner");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "owner", (Object)this.owner, (Object)string);
            return;
        }
        this.owner = string;
    }
}

