/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownListenerBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.deployment.util.WebJarUtil;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.runtime.shutdown.ShutdownListener;
import io.quarkus.smallrye.health.deployment.HealthBuildTimeConfig;
import io.quarkus.smallrye.health.deployment.HealthOpenAPIFilter;
import io.quarkus.smallrye.health.deployment.SmallRyeHealthBuildItem;
import io.quarkus.smallrye.health.deployment.SmallRyeHealthConfig;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.smallrye.health.runtime.ShutdownReadinessListener;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthGroupHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthRecorder;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthRuntimeConfig;
import io.quarkus.smallrye.health.runtime.SmallRyeIndividualHealthGroupHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeLivenessHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeReadinessHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeWellnessHandler;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.smallrye.health.SmallRyeHealthReporter;
import io.smallrye.health.api.HealthGroup;
import io.smallrye.health.api.HealthGroups;
import io.smallrye.health.api.Wellness;
import io.vertx.core.Handler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

class SmallRyeHealthProcessor {
    private static final Logger LOG = Logger.getLogger(SmallRyeHealthProcessor.class);
    private static final DotName HEALTH = DotName.createSimple((String)Health.class.getName());
    private static final DotName LIVENESS = DotName.createSimple((String)Liveness.class.getName());
    private static final DotName READINESS = DotName.createSimple((String)Readiness.class.getName());
    private static final DotName HEALTH_GROUP = DotName.createSimple((String)HealthGroup.class.getName());
    private static final DotName HEALTH_GROUPS = DotName.createSimple((String)HealthGroups.class.getName());
    private static final DotName WELLNESS = DotName.createSimple((String)Wellness.class.getName());
    private static final DotName JAX_RS_PATH = DotName.createSimple((String)"javax.ws.rs.Path");
    private static final String HEALTH_UI_WEBJAR_GROUP_ID = "io.smallrye";
    private static final String HEALTH_UI_WEBJAR_ARTIFACT_ID = "smallrye-health-ui";
    private static final String HEALTH_UI_WEBJAR_PREFIX = "META-INF/resources/health-ui/";
    private static final String HEALTH_UI_FINAL_DESTINATION = "META-INF/health-ui-files";
    private static final String FILE_TO_UPDATE = "healthui.js";
    HealthBuildTimeConfig config;

    SmallRyeHealthProcessor() {
    }

    @BuildStep
    void healthCheck(BuildProducer<AdditionalBeanBuildItem> buildItemBuildProducer, List<HealthBuildItem> healthBuildItems) {
        boolean extensionsEnabled;
        boolean bl = extensionsEnabled = this.config.extensionsEnabled && ConfigProvider.getConfig().getOptionalValue("mp.health.disable-default-procedures", Boolean.TYPE).orElse(false) == false;
        if (extensionsEnabled) {
            for (HealthBuildItem buildItem : healthBuildItems) {
                if (!buildItem.isEnabled()) continue;
                buildItemBuildProducer.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{buildItem.getHealthCheckClass()}));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(SmallRyeHealthRecorder recorder, BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotation, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, LaunchModeBuildItem launchMode, SmallRyeHealthConfig healthConfig) throws IOException, ClassNotFoundException {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_HEALTH));
        if (launchMode.getLaunchMode().isDevOrTest()) {
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(healthConfig.rootPath));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(healthConfig.rootPath + healthConfig.livenessPath));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(healthConfig.rootPath + healthConfig.readinessPath));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(healthConfig.rootPath + healthConfig.groupPath));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(healthConfig.rootPath + healthConfig.wellnessPath));
        }
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(HEALTH));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(LIVENESS));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(READINESS));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(HEALTH_GROUP));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(HEALTH_GROUPS));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(WELLNESS));
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SmallRyeHealthReporter.class}));
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{HealthGroup.class}));
        Set providers = ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)("META-INF/services/" + HealthCheckResponseProvider.class.getName()));
        if (providers.isEmpty()) {
            throw new IllegalStateException("No HealthCheckResponseProvider implementation found.");
        }
        if (providers.size() > 1) {
            throw new IllegalStateException(String.format("Multiple HealthCheckResponseProvider implementations found: %s", providers));
        }
        String provider = (String)providers.iterator().next();
        Class<?> responseProvider = Class.forName(provider, true, Thread.currentThread().getContextClassLoader());
        recorder.registerHealthCheckResponseProvider(responseProvider);
    }

    @BuildStep
    public void defineHealthRoutes(BuildProducer<RouteBuildItem> routes, BeanArchiveIndexBuildItem beanArchiveIndex, SmallRyeHealthConfig healthConfig) {
        IndexView index = beanArchiveIndex.getIndex();
        this.warnIfJaxRsPathUsed(index, LIVENESS);
        this.warnIfJaxRsPathUsed(index, READINESS);
        this.warnIfJaxRsPathUsed(index, HEALTH);
        this.warnIfJaxRsPathUsed(index, WELLNESS);
        routes.produce((BuildItem)new RouteBuildItem(healthConfig.rootPath, (Handler)new SmallRyeHealthHandler(), HandlerType.BLOCKING));
        routes.produce((BuildItem)new RouteBuildItem(healthConfig.rootPath + healthConfig.livenessPath, (Handler)new SmallRyeLivenessHandler(), HandlerType.BLOCKING));
        routes.produce((BuildItem)new RouteBuildItem(healthConfig.rootPath + healthConfig.readinessPath, (Handler)new SmallRyeReadinessHandler(), HandlerType.BLOCKING));
        HashSet<String> healthGroups = new HashSet<String>();
        for (AnnotationInstance healthGroupAnnotation : index.getAnnotations(HEALTH_GROUP)) {
            healthGroups.add(healthGroupAnnotation.value().asString());
        }
        for (AnnotationInstance healthGroupsAnnotation : index.getAnnotations(HEALTH_GROUPS)) {
            for (AnnotationInstance healthGroupAnnotation : healthGroupsAnnotation.value().asNestedArray()) {
                healthGroups.add(healthGroupAnnotation.value().asString());
            }
        }
        routes.produce((BuildItem)new RouteBuildItem(healthConfig.rootPath + healthConfig.groupPath, (Handler)new SmallRyeHealthGroupHandler(), HandlerType.BLOCKING));
        SmallRyeIndividualHealthGroupHandler handler = new SmallRyeIndividualHealthGroupHandler();
        for (String healthGroup : healthGroups) {
            routes.produce((BuildItem)new RouteBuildItem(healthConfig.rootPath + healthConfig.groupPath + "/" + healthGroup, (Handler)handler, HandlerType.BLOCKING));
        }
        routes.produce((BuildItem)new RouteBuildItem(healthConfig.rootPath + healthConfig.wellnessPath, (Handler)new SmallRyeWellnessHandler(), HandlerType.BLOCKING));
    }

    @BuildStep(onlyIf={OpenAPIIncluded.class})
    public void includeInOpenAPIEndpoint(BuildProducer<AddToOpenAPIDefinitionBuildItem> openAPIProducer, Capabilities capabilities, SmallRyeHealthConfig healthConfig) {
        if (capabilities.isPresent(Capability.SMALLRYE_OPENAPI)) {
            HealthOpenAPIFilter filter = new HealthOpenAPIFilter(healthConfig.rootPath, healthConfig.rootPath + healthConfig.livenessPath, healthConfig.rootPath + healthConfig.readinessPath);
            openAPIProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)filter));
        }
    }

    private void warnIfJaxRsPathUsed(IndexView index, DotName healthAnnotation) {
        Collection instances = index.getAnnotations(healthAnnotation);
        for (AnnotationInstance instance : instances) {
            boolean containsPath = false;
            AnnotationTarget target = instance.target();
            if (target.kind() == AnnotationTarget.Kind.CLASS) {
                if (target.asClass().classAnnotation(JAX_RS_PATH) != null) {
                    containsPath = true;
                }
            } else if (target.kind() == AnnotationTarget.Kind.METHOD && target.asMethod().hasAnnotation(JAX_RS_PATH)) {
                containsPath = true;
            }
            if (!containsPath) continue;
            LOG.warnv("The use of @Path has no effect when @{0} is used and should therefore be removed. Offending target is {1}: {2}", (Object)healthAnnotation.withoutPackagePrefix(), (Object)target.kind(), (Object)target);
        }
    }

    @BuildStep
    public void kubernetes(HttpBuildTimeConfig httpConfig, SmallRyeHealthConfig healthConfig, BuildProducer<KubernetesHealthLivenessPathBuildItem> livenessPathItemProducer, BuildProducer<KubernetesHealthReadinessPathBuildItem> readinessPathItemProducer) {
        if (httpConfig.rootPath == null) {
            livenessPathItemProducer.produce((BuildItem)new KubernetesHealthLivenessPathBuildItem(healthConfig.rootPath + healthConfig.livenessPath));
            readinessPathItemProducer.produce((BuildItem)new KubernetesHealthReadinessPathBuildItem(healthConfig.rootPath + healthConfig.readinessPath));
        } else {
            String basePath = httpConfig.rootPath.replaceAll("/$", "") + healthConfig.rootPath;
            livenessPathItemProducer.produce((BuildItem)new KubernetesHealthLivenessPathBuildItem(basePath + healthConfig.livenessPath));
            readinessPathItemProducer.produce((BuildItem)new KubernetesHealthReadinessPathBuildItem(basePath + healthConfig.readinessPath));
        }
    }

    @BuildStep
    ShutdownListenerBuildItem shutdownListener() {
        return new ShutdownListenerBuildItem((ShutdownListener)new ShutdownReadinessListener());
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformer(BeanArchiveIndexBuildItem beanArchiveIndex, final CustomScopeAnnotationsBuildItem scopes) {
        final Set stereotypes = beanArchiveIndex.getIndex().getAnnotations(DotNames.STEREOTYPE).stream().map(AnnotationInstance::name).collect(Collectors.toSet());
        final ArrayList<DotName> healthAnnotations = new ArrayList<DotName>(5);
        healthAnnotations.add(HEALTH);
        healthAnnotations.add(LIVENESS);
        healthAnnotations.add(READINESS);
        healthAnnotations.add(HEALTH_GROUP);
        healthAnnotations.add(HEALTH_GROUPS);
        healthAnnotations.add(WELLNESS);
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS || kind == AnnotationTarget.Kind.METHOD;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                Collection annotations;
                if (ctx.getAnnotations().isEmpty()) {
                    return;
                }
                if (ctx.isClass()) {
                    annotations = ctx.getAnnotations();
                    if (Annotations.containsAny((Collection)annotations, (Iterable)stereotypes)) {
                        return;
                    }
                } else {
                    annotations = Annotations.getAnnotations((AnnotationTarget.Kind)AnnotationTarget.Kind.METHOD, (Collection)ctx.getAnnotations());
                }
                if (scopes.isScopeIn(annotations)) {
                    return;
                }
                if (Annotations.containsAny((Collection)annotations, (Iterable)healthAnnotations)) {
                    ((Transformation)ctx.transform().add(BuiltinScope.SINGLETON.getName(), new AnnotationValue[0])).done();
                }
            }
        });
    }

    @BuildStep
    void registerUiExtension(BuildProducer<GeneratedResourceBuildItem> generatedResourceProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> notFoundPageDisplayableEndpointProducer, BuildProducer<SmallRyeHealthBuildItem> smallRyeHealthBuildProducer, HttpRootPathBuildItem httpRootPath, SmallRyeHealthConfig healthConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, LaunchModeBuildItem launchMode) throws Exception {
        if (SmallRyeHealthProcessor.shouldInclude(launchMode, healthConfig)) {
            if ("/".equals(healthConfig.ui.rootPath)) {
                throw new ConfigurationError("quarkus.smallrye-health.root-path-ui was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
            }
            String healthPath = httpRootPath.adjustPath(healthConfig.rootPath);
            AppArtifact artifact = WebJarUtil.getAppArtifact((CurateOutcomeBuildItem)curateOutcomeBuildItem, (String)HEALTH_UI_WEBJAR_GROUP_ID, (String)HEALTH_UI_WEBJAR_ARTIFACT_ID);
            if (launchMode.getLaunchMode().isDevOrTest()) {
                Path tempPath = WebJarUtil.devOrTest((CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)launchMode, (AppArtifact)artifact, (String)HEALTH_UI_WEBJAR_PREFIX);
                this.updateApiUrl(tempPath.resolve(FILE_TO_UPDATE), healthPath);
                smallRyeHealthBuildProducer.produce((BuildItem)new SmallRyeHealthBuildItem(tempPath.toAbsolutePath().toString(), httpRootPath.adjustPath(healthConfig.ui.rootPath)));
                notFoundPageDisplayableEndpointProducer.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(healthConfig.ui.rootPath + "/"));
            } else {
                Map files = WebJarUtil.production((CurateOutcomeBuildItem)curateOutcomeBuildItem, (AppArtifact)artifact, (String)HEALTH_UI_WEBJAR_PREFIX);
                for (Map.Entry file : files.entrySet()) {
                    String fileName = (String)file.getKey();
                    byte[] content = (byte[])file.getValue();
                    if (fileName.endsWith(FILE_TO_UPDATE)) {
                        content = this.updateApiUrl(new String(content, StandardCharsets.UTF_8), healthPath).getBytes(StandardCharsets.UTF_8);
                    }
                    fileName = "META-INF/health-ui-files/" + fileName;
                    generatedResourceProducer.produce((BuildItem)new GeneratedResourceBuildItem(fileName, content));
                    nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
                }
                smallRyeHealthBuildProducer.produce((BuildItem)new SmallRyeHealthBuildItem(HEALTH_UI_FINAL_DESTINATION, httpRootPath.adjustPath(healthConfig.ui.rootPath)));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerHealthUiHandler(BuildProducer<RouteBuildItem> routeProducer, SmallRyeHealthRecorder recorder, SmallRyeHealthRuntimeConfig runtimeConfig, SmallRyeHealthBuildItem smallRyeHealthBuildItem, LaunchModeBuildItem launchMode, SmallRyeHealthConfig healthConfig) throws Exception {
        if (SmallRyeHealthProcessor.shouldInclude(launchMode, healthConfig)) {
            Handler handler = recorder.uiHandler(smallRyeHealthBuildItem.getHealthUiFinalDestination(), smallRyeHealthBuildItem.getHealthUiPath(), runtimeConfig);
            routeProducer.produce((BuildItem)new RouteBuildItem(healthConfig.ui.rootPath, handler));
            routeProducer.produce((BuildItem)new RouteBuildItem(healthConfig.ui.rootPath + "/*", handler));
        }
    }

    private void updateApiUrl(Path healthUiJs, String healthPath) throws IOException {
        String content = new String(Files.readAllBytes(healthUiJs), StandardCharsets.UTF_8);
        String result = this.updateApiUrl(content, healthPath);
        if (result != null) {
            Files.write(healthUiJs, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public String updateApiUrl(String original, String healthPath) {
        return original.replace("url = \"/health\";", "url = \"" + healthPath + "\";");
    }

    private static boolean shouldInclude(LaunchModeBuildItem launchMode, SmallRyeHealthConfig healthConfig) {
        return launchMode.getLaunchMode().isDevOrTest() || healthConfig.ui.alwaysInclude;
    }

    static class OpenAPIIncluded
    implements BooleanSupplier {
        HealthBuildTimeConfig config;

        OpenAPIIncluded() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.openapiIncluded;
        }
    }
}

