/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.ResultNode;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public class MultiResultNode
implements ResultNode {
    private final ResultNode[] results;

    public MultiResultNode(CompletableFuture<ResultNode>[] futures) {
        this.results = new ResultNode[futures.length];
        for (int i = 0; i < futures.length; ++i) {
            try {
                this.results[i] = futures[i].get();
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void process(Consumer<String> consumer) {
        for (ResultNode result : this.results) {
            result.process(consumer);
        }
    }
}

