/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.classic;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.HttpRoute;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.classic.ExecRuntime;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.config.RequestConfig;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.ConnPoolSupport;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.classic.RequestFailedException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.io.ConnectionEndpoint;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.io.HttpClientConnectionManager;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.io.LeaseRequest;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.concurrent.Cancellable;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.concurrent.CancellableDependency;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ClassicHttpRequest;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ClassicHttpResponse;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.io.CloseMode;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Args;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.TimeValue;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

class InternalExecRuntime
implements ExecRuntime,
Cancellable {
    private final Logger log;
    private final HttpClientConnectionManager manager;
    private final HttpRequestExecutor requestExecutor;
    private final CancellableDependency cancellableDependency;
    private final AtomicReference<ConnectionEndpoint> endpointRef;
    private volatile boolean reusable;
    private volatile Object state;
    private volatile TimeValue validDuration;

    InternalExecRuntime(Logger log, HttpClientConnectionManager manager, HttpRequestExecutor requestExecutor, CancellableDependency cancellableDependency) {
        this.log = log;
        this.manager = manager;
        this.requestExecutor = requestExecutor;
        this.cancellableDependency = cancellableDependency;
        this.endpointRef = new AtomicReference<Object>(null);
        this.validDuration = TimeValue.NEG_ONE_MILLISECOND;
    }

    @Override
    public boolean isExecutionAborted() {
        return this.cancellableDependency != null && this.cancellableDependency.isCancelled();
    }

    @Override
    public boolean isEndpointAcquired() {
        return this.endpointRef.get() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void acquireEndpoint(String id, HttpRoute route, Object object, HttpClientContext context) throws IOException {
        Args.notNull(route, "Route");
        if (this.endpointRef.get() != null) throw new IllegalStateException("Endpoint already acquired");
        RequestConfig requestConfig = context.getRequestConfig();
        Timeout connectionRequestTimeout = requestConfig.getConnectionRequestTimeout();
        if (this.log.isDebugEnabled()) {
            this.log.debug(id + ": acquiring endpoint (" + connectionRequestTimeout + ")");
        }
        LeaseRequest connRequest = this.manager.lease(id, route, connectionRequestTimeout, object);
        this.state = object;
        if (this.cancellableDependency != null) {
            if (this.cancellableDependency.isCancelled()) {
                connRequest.cancel();
                throw new RequestFailedException("Request aborted");
            }
            this.cancellableDependency.setDependency(connRequest);
        }
        try {
            ConnectionEndpoint connectionEndpoint = connRequest.get(connectionRequestTimeout);
            this.endpointRef.set(connectionEndpoint);
            this.reusable = connectionEndpoint.isConnected();
            if (this.cancellableDependency != null) {
                this.cancellableDependency.setDependency(this);
            }
            if (!this.log.isDebugEnabled()) return;
            this.log.debug(id + ": acquired endpoint " + ConnPoolSupport.getId(connectionEndpoint));
            return;
        }
        catch (TimeoutException ex) {
            throw new ConnectionRequestTimeoutException(ex.getMessage());
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new RequestFailedException("Request aborted", interrupted);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) throw new RequestFailedException("Request execution failed", cause);
            cause = ex;
            throw new RequestFailedException("Request execution failed", cause);
        }
    }

    ConnectionEndpoint ensureValid() {
        ConnectionEndpoint endpoint = this.endpointRef.get();
        if (endpoint == null) {
            throw new IllegalStateException("Endpoint not acquired / already released");
        }
        return endpoint;
    }

    @Override
    public boolean isEndpointConnected() {
        ConnectionEndpoint endpoint = this.endpointRef.get();
        return endpoint != null && endpoint.isConnected();
    }

    private void connectEndpoint(ConnectionEndpoint endpoint, HttpClientContext context) throws IOException {
        if (this.cancellableDependency != null && this.cancellableDependency.isCancelled()) {
            throw new RequestFailedException("Request aborted");
        }
        RequestConfig requestConfig = context.getRequestConfig();
        Timeout connectTimeout = requestConfig.getConnectTimeout();
        if (this.log.isDebugEnabled()) {
            this.log.debug(ConnPoolSupport.getId(endpoint) + ": connecting endpoint (" + connectTimeout + ")");
        }
        this.manager.connect(endpoint, connectTimeout, context);
        if (this.log.isDebugEnabled()) {
            this.log.debug(ConnPoolSupport.getId(endpoint) + ": endpoint connected");
        }
    }

    @Override
    public void connectEndpoint(HttpClientContext context) throws IOException {
        ConnectionEndpoint endpoint = this.ensureValid();
        if (!endpoint.isConnected()) {
            this.connectEndpoint(endpoint, context);
        }
    }

    @Override
    public void disconnectEndpoint() throws IOException {
        ConnectionEndpoint endpoint = this.endpointRef.get();
        if (endpoint != null) {
            endpoint.close();
            if (this.log.isDebugEnabled()) {
                this.log.debug(ConnPoolSupport.getId(endpoint) + ": endpoint closed");
            }
        }
    }

    @Override
    public void upgradeTls(HttpClientContext context) throws IOException {
        ConnectionEndpoint endpoint = this.ensureValid();
        RequestConfig requestConfig = context.getRequestConfig();
        Timeout connectTimeout = requestConfig.getConnectTimeout();
        if (TimeValue.isPositive(connectTimeout)) {
            endpoint.setSocketTimeout(connectTimeout);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(ConnPoolSupport.getId(endpoint) + ": upgrading endpoint (" + connectTimeout + ")");
        }
        this.manager.upgrade(endpoint, context);
    }

    @Override
    public ClassicHttpResponse execute(String id, ClassicHttpRequest request, HttpClientContext context) throws IOException, HttpException {
        RequestConfig requestConfig;
        Timeout responseTimeout;
        ConnectionEndpoint endpoint = this.ensureValid();
        if (!endpoint.isConnected()) {
            this.connectEndpoint(endpoint, context);
        }
        if ((responseTimeout = (requestConfig = context.getRequestConfig()).getResponseTimeout()) != null) {
            endpoint.setSocketTimeout(responseTimeout);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(ConnPoolSupport.getId(endpoint) + ": start execution " + id);
        }
        return endpoint.execute(id, request, this.requestExecutor, context);
    }

    @Override
    public boolean isConnectionReusable() {
        return this.reusable;
    }

    @Override
    public void markConnectionReusable(Object state, TimeValue validDuration) {
        this.reusable = true;
        this.state = state;
        this.validDuration = validDuration;
    }

    @Override
    public void markConnectionNonReusable() {
        this.reusable = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardEndpoint(ConnectionEndpoint endpoint) {
        try {
            endpoint.close(CloseMode.IMMEDIATE);
            if (this.log.isDebugEnabled()) {
                this.log.debug(ConnPoolSupport.getId(endpoint) + ": endpoint closed");
            }
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.log.debug(ConnPoolSupport.getId(endpoint) + ": discarding endpoint");
            }
            this.manager.release(endpoint, null, TimeValue.ZERO_MILLISECONDS);
        }
    }

    @Override
    public void releaseEndpoint() {
        ConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            if (this.reusable) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(ConnPoolSupport.getId(endpoint) + ": releasing valid endpoint");
                }
                this.manager.release(endpoint, this.state, this.validDuration);
            } else {
                this.discardEndpoint(endpoint);
            }
        }
    }

    @Override
    public void discardEndpoint() {
        ConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            this.discardEndpoint(endpoint);
        }
    }

    @Override
    public boolean cancel() {
        boolean alreadyReleased = this.endpointRef.get() == null;
        ConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(ConnPoolSupport.getId(endpoint) + ": cancel");
            }
            this.discardEndpoint(endpoint);
        }
        return !alreadyReleased;
    }

    @Override
    public ExecRuntime fork(CancellableDependency cancellableDependency) {
        return new InternalExecRuntime(this.log, this.manager, this.requestExecutor, cancellableDependency);
    }
}

