/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.quarkus.arc.runtime.ConfigRecorder;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescription;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescriptionsSupplier;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class ConfigEditorProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public DevConsoleRuntimeTemplateInfoBuildItem config(ConfigRecorder recorder, List<ConfigDescriptionBuildItem> configDescriptionBuildItems) {
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>();
        for (ConfigDescriptionBuildItem item : configDescriptionBuildItems) {
            configDescriptions.add(new ConfigDescription(item.getPropertyName(), item.getDocs(), item.getDefaultValue()));
        }
        return new DevConsoleRuntimeTemplateInfoBuildItem("config", (Supplier)new ConfigDescriptionsSupplier(configDescriptions));
    }

    @BuildStep
    DevConsoleRouteBuildItem handlePost() {
        return new DevConsoleRouteBuildItem("config", "POST", (Handler)new DevConsolePostHandler(){

            protected void handlePost(RoutingContext event, MultiMap form) throws Exception {
                String profile;
                String name = event.request().getFormAttribute("name");
                String value = event.request().getFormAttribute("value");
                List resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
                if (resourcesDir.isEmpty()) {
                    throw new IllegalStateException("Unable to manage configurations - no resource directory found");
                }
                Path path = (Path)resourcesDir.get(0);
                Path configPath = path.resolve("application.properties");
                if (!Files.exists(configPath, new LinkOption[0])) {
                    configPath = Files.createFile(path.resolve("application.properties"), new FileAttribute[0]);
                }
                name = !(profile = ProfileManager.getActiveProfile()).equals(LaunchMode.DEVELOPMENT.getDefaultProfile()) ? "%" + profile + "." + name : name;
                List<String> lines = Files.readAllLines(configPath);
                int nameLine = -1;
                int linesSize = lines.size();
                for (int i = 0; i < linesSize; ++i) {
                    String line = lines.get(i);
                    if (!line.startsWith(name + "=")) continue;
                    nameLine = i;
                    break;
                }
                if (nameLine != -1) {
                    if (value.isEmpty()) {
                        lines.remove(nameLine);
                    } else {
                        lines.set(nameLine, name + "=" + value);
                    }
                } else if (!value.isEmpty()) {
                    lines.add(name + "=" + value);
                }
                try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                    for (String i : lines) {
                        writer.write(i);
                        writer.newLine();
                    }
                }
                DevConsoleManager.getHotReplacementContext().doScan(true);
                this.flashMessage(event, "Configuration updated");
            }
        });
    }
}

