/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate13_0_0_MigrateDefaultRoles
extends CustomKeycloakTask {
    private final Set<String> realmIds = new HashSet<String>();

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        this.extractRealmIds("SELECT ID FROM " + this.getTableName("REALM"));
        String clientTable = this.getTableName("CLIENT");
        String clientDefaultRolesTable = this.getTableName("CLIENT_DEFAULT_ROLES");
        String compositeRoleTable = this.getTableName("COMPOSITE_ROLE");
        for (String realmId : this.realmIds) {
            String id = UUID.randomUUID().toString();
            String roleName = this.determineDefaultRoleName(realmId);
            this.statements.add(new InsertStatement(null, null, this.database.correctObjectName("KEYCLOAK_ROLE", Table.class)).addColumnValue("ID", (Object)id).addColumnValue("CLIENT_REALM_CONSTRAINT", (Object)realmId).addColumnValue("CLIENT_ROLE", (Object)Boolean.FALSE).addColumnValue("DESCRIPTION", (Object)("${role_" + roleName + "}")).addColumnValue("NAME", (Object)roleName).addColumnValue("REALM_ID", (Object)realmId).addColumnValue("REALM", (Object)realmId));
            this.statements.add(new UpdateStatement(null, null, this.database.correctObjectName("REALM", Table.class)).addNewColumnValue("DEFAULT_ROLE", (Object)id).setWhereClause("REALM.ID = '" + realmId + "'"));
            this.statements.add(new RawSqlStatement("INSERT INTO " + compositeRoleTable + " (COMPOSITE, CHILD_ROLE) SELECT '" + id + "', ROLE_ID FROM " + this.getTableName("REALM_DEFAULT_ROLES") + " WHERE REALM_ID = '" + realmId + "'"));
            this.statements.add(new RawSqlStatement("INSERT INTO " + compositeRoleTable + " (COMPOSITE, CHILD_ROLE) SELECT '" + id + "', " + clientDefaultRolesTable + ".ROLE_ID FROM " + clientDefaultRolesTable + " INNER JOIN " + clientTable + " ON " + clientTable + ".ID = " + clientDefaultRolesTable + ".CLIENT_ID AND " + clientTable + ".REALM_ID = '" + realmId + "'"));
        }
    }

    private void extractRealmIds(String sql) throws CustomChangeException {
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement(sql);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                String realmId = rs.getString(1);
                if (realmId == null || realmId.trim().isEmpty()) continue;
                this.realmIds.add(realmId);
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when extracting data from previous version", (Throwable)e);
        }
    }

    private String determineDefaultRoleName(String realmId) throws CustomChangeException {
        String roleName = "default-roles-" + realmId.toLowerCase();
        if (this.isRoleNameAvailable(realmId, roleName)) {
            return roleName;
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            roleName = "default-roles-" + realmId.toLowerCase() + "-" + i;
            if (!this.isRoleNameAvailable(realmId, roleName)) continue;
            return roleName;
        }
        throw new CustomChangeException(this.getTaskId() + ": Exception when extracting data from previous version. Unable to determine default role name.");
    }

    /*
     * Exception decompiling
     */
    private boolean isRoleNameAvailable(String realmId, String roleName) throws CustomChangeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected String getTaskId() {
        return "Migrate Default roles (13.0.0)";
    }
}

