/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.keycloak.common.util.Base64Url;
import org.keycloak.models.utils.KeycloakModelUtils;

public class PkceUtils {
    public static String generateCodeVerifier() {
        return Base64Url.encode((byte[])KeycloakModelUtils.generateSecret((int)64));
    }

    public static String encodeCodeChallenge(String codeVerifier, String codeChallengeMethod) {
        try {
            switch (codeChallengeMethod) {
                case "S256": {
                    return PkceUtils.generateS256CodeChallenge(codeVerifier);
                }
            }
            return codeVerifier;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String generateS256CodeChallenge(String codeVerifier) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(codeVerifier.getBytes(StandardCharsets.ISO_8859_1));
        byte[] digestBytes = md.digest();
        return Base64Url.encode((byte[])digestBytes);
    }

    public static boolean validateCodeChallenge(String verifier, String codeChallenge, String codeChallengeMethod) {
        try {
            switch (codeChallengeMethod) {
                case "plain": {
                    return verifier.equals(codeChallenge);
                }
                case "S256": {
                    return PkceUtils.generateS256CodeChallenge(verifier).equals(codeChallenge);
                }
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

