/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.protocol.saml.ArtifactResolver;
import org.keycloak.protocol.saml.ArtifactResolverProcessingException;
import org.keycloak.protocol.saml.DefaultSamlArtifactResolverFactory;
import org.keycloak.protocol.saml.SamlService;

public class DefaultSamlArtifactResolver
implements ArtifactResolver {
    protected static final Logger logger = Logger.getLogger(SamlService.class);

    public String resolveArtifact(AuthenticatedClientSessionModel clientSessionModel, String artifact) throws ArtifactResolverProcessingException {
        String artifactResponseString = clientSessionModel.getNote("SAMLart=" + artifact);
        clientSessionModel.removeNote("SAMLart=" + artifact);
        logger.tracef("Artifact response for artifact %s, is %s", (Object)artifact, (Object)artifactResponseString);
        if (Strings.isNullOrEmpty((String)artifactResponseString)) {
            throw new ArtifactResolverProcessingException("Artifact not present in ClientSession.");
        }
        return artifactResponseString;
    }

    public ClientModel selectSourceClient(String artifact, Stream<ClientModel> clients) throws ArtifactResolverProcessingException {
        try {
            byte[] source = this.extractSourceFromArtifact(artifact);
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            return clients.filter(clientModel -> Arrays.equals(source, sha1Digester.digest(clientModel.getClientId().getBytes(Charsets.UTF_8)))).findFirst().orElseThrow(() -> new ArtifactResolverProcessingException("No client matching the artifact source found"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new ArtifactResolverProcessingException((Exception)e);
        }
    }

    public String buildArtifact(AuthenticatedClientSessionModel clientSessionModel, String entityId, String artifactResponse) throws ArtifactResolverProcessingException {
        String artifact = this.createArtifact(entityId);
        clientSessionModel.setNote("SAMLart=" + artifact, artifactResponse);
        return artifact;
    }

    private void assertSupportedArtifactFormat(String artifactString) throws ArtifactResolverProcessingException {
        byte[] artifact = Base64.getDecoder().decode(artifactString);
        if (artifact.length != 44) {
            throw new ArtifactResolverProcessingException("Artifact " + artifactString + " has a length of " + artifact.length + ". It should be 44");
        }
        if (artifact[0] != DefaultSamlArtifactResolverFactory.TYPE_CODE[0] || artifact[1] != DefaultSamlArtifactResolverFactory.TYPE_CODE[1]) {
            throw new ArtifactResolverProcessingException("Artifact " + artifactString + " does not start with 0x0004");
        }
    }

    private byte[] extractSourceFromArtifact(String artifactString) throws ArtifactResolverProcessingException {
        this.assertSupportedArtifactFormat(artifactString);
        byte[] artifact = Base64.getDecoder().decode(artifactString);
        byte[] source = new byte[20];
        System.arraycopy(artifact, 4, source, 0, source.length);
        return source;
    }

    public String createArtifact(String entityId) throws ArtifactResolverProcessingException {
        try {
            SecureRandom handleGenerator = SecureRandom.getInstance("SHA1PRNG");
            byte[] trimmedIndex = new byte[2];
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            byte[] source = sha1Digester.digest(entityId.getBytes(Charsets.UTF_8));
            byte[] assertionHandle = new byte[20];
            handleGenerator.nextBytes(assertionHandle);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(DefaultSamlArtifactResolverFactory.TYPE_CODE);
            bos.write(trimmedIndex);
            bos.write(source);
            bos.write(assertionHandle);
            byte[] artifact = bos.toByteArray();
            return Base64.getEncoder().encodeToString(artifact);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ArtifactResolverProcessingException("JVM does not support required cryptography algorithms: SHA-1/SHA1PRNG.", (Exception)e);
        }
        catch (IOException e) {
            throw new ArtifactResolverProcessingException((Exception)e);
        }
    }

    public void close() {
    }
}

