/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointRequestParser;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorConfiguration;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureRequestObjectExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(SecureRequestObjectExecutor.class);
    public static final String INVALID_REQUEST_OBJECT = "invalid_request_object";
    public static final Integer DEFAULT_AVAILABLE_PERIOD = 3600;
    private final KeycloakSession session;
    private Configuration configuration;

    public SecureRequestObjectExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "secure-reqobj-executor";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: {
                AuthorizationRequestContext authorizationRequestContext = (AuthorizationRequestContext)context;
                this.executeOnAuthorizationRequest(authorizationRequestContext.getparsedResponseType(), authorizationRequestContext.getAuthorizationEndpointRequest(), authorizationRequestContext.getRedirectUri(), authorizationRequestContext.getRequestParameters());
                break;
            }
            default: {
                return;
            }
        }
    }

    private void executeOnAuthorizationRequest(OIDCResponseType parsedResponseType, AuthorizationEndpointRequest request, String redirectUri, MultivaluedMap<String, String> params) throws ClientPolicyException {
        logger.trace((Object)"Authz Endpoint - authz request");
        if (params == null) {
            logger.trace((Object)"request parameter not exist.");
            throw new ClientPolicyException("invalid_request", "Missing parameters");
        }
        String requestParam = (String)params.getFirst((Object)"request");
        String requestUriParam = (String)params.getFirst((Object)"request_uri");
        if (requestParam == null && requestUriParam == null) {
            logger.trace((Object)"request object not exist.");
            throw new ClientPolicyException("invalid_request", "Invalid parameter");
        }
        JsonNode requestObject = (JsonNode)this.session.getAttribute("ParsedRequestObject");
        if (requestObject == null || requestObject.isEmpty()) {
            logger.trace((Object)"request object not exist.");
            throw new ClientPolicyException("invalid_request", "Invalid parameter");
        }
        if (params.getFirst((Object)"scope") == null || requestObject.get("scope") == null) {
            logger.trace((Object)"scope object not exist.");
            throw new ClientPolicyException("invalid_request", "Missing parameter : scope");
        }
        if (requestObject.get("exp") == null) {
            logger.trace((Object)"exp claim not incuded.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Missing parameter : exp");
        }
        long exp = requestObject.get("exp").asLong();
        if ((long)Time.currentTime() > exp) {
            logger.trace((Object)"request object expired.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Request Expired");
        }
        if (requestObject.get("nbf") == null) {
            logger.trace((Object)"nbf claim not incuded.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Missing parameter : nbf");
        }
        long nbf = requestObject.get("nbf").asLong();
        if ((long)Time.currentTime() < nbf) {
            logger.trace((Object)"request object not yet being processed.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Request not yet being processed");
        }
        int availablePeriod = Optional.ofNullable(this.configuration.getAvailablePeriod()).orElse(DEFAULT_AVAILABLE_PERIOD);
        if (exp - nbf > (long)availablePeriod) {
            logger.trace((Object)"request object's available period is long.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Request's available period is long");
        }
        ArrayList<String> aud = new ArrayList<String>();
        JsonNode audience = requestObject.get("aud");
        if (audience == null) {
            logger.trace((Object)"aud claim not incuded.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Missing parameter : aud");
        }
        if (audience.isArray()) {
            for (JsonNode node : audience) {
                aud.add(node.asText());
            }
        } else {
            aud.add(audience.asText());
        }
        if (aud.isEmpty()) {
            logger.trace((Object)"aud claim not incuded.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Missing parameter : aud");
        }
        String iss = Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.session.getContext().getRealm().getName());
        if (!aud.contains(iss)) {
            logger.trace((Object)"aud not points to the intended realm.");
            throw new ClientPolicyException(INVALID_REQUEST_OBJECT, "Invalid parameter : aud");
        }
        if (AuthzEndpointRequestParser.KNOWN_REQ_PARAMS.stream().filter(s -> params.containsKey(s)).anyMatch(s -> !this.isSameParameterIncluded((String)s, (String)params.getFirst(s), requestObject))) {
            logger.trace((Object)"not all parameters in query string are included in the request object, and have the same values.");
            throw new ClientPolicyException("invalid_request", "Invalid parameter");
        }
        logger.trace((Object)"Passed.");
    }

    private boolean isSameParameterIncluded(String param, String value, JsonNode requestObject) {
        if (param.equals("request") || param.equals("request_uri")) {
            return true;
        }
        if (requestObject.hasNonNull(param)) {
            return requestObject.get(param).asText().equals(value);
        }
        return false;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Configuration
    extends ClientPolicyExecutorConfiguration {
        @JsonProperty(value="available-period")
        protected Integer availablePeriod;

        public Integer getAvailablePeriod() {
            return this.availablePeriod;
        }

        public void setAvailablePeriod(Integer availablePeriod) {
            this.availablePeriod = availablePeriod;
        }
    }
}

