/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.filters;

import java.util.function.Consumer;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Resteasy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.services.resources.KeycloakApplication;

public abstract class AbstractRequestFilter {
    protected void filter(ClientConnection clientConnection, Consumer<KeycloakSession> next) {
        KeycloakSessionFactory sessionFactory = this.getSessionFactory();
        KeycloakSession session = sessionFactory.create();
        KeycloakTransactionManager tx = session.getTransactionManager();
        tx.begin();
        try {
            Resteasy.pushContext(ClientConnection.class, clientConnection);
            Resteasy.pushContext(KeycloakSession.class, session);
            next.accept(session);
        }
        catch (Exception e) {
            tx.setRollbackOnly();
            throw new RuntimeException(e);
        }
        finally {
            if (this.isAutoClose()) {
                this.close(session);
            }
        }
    }

    protected KeycloakSessionFactory getSessionFactory() {
        return KeycloakApplication.getSessionFactory();
    }

    protected void close(KeycloakSession session) {
        KeycloakTransactionManager tx = session.getTransactionManager();
        if (tx.isActive()) {
            if (tx.getRollbackOnly()) {
                tx.rollback();
            } else {
                tx.commit();
            }
        }
        session.close();
    }

    protected boolean isAutoClose() {
        return true;
    }
}

