/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.client.ClientLookupProvider;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.storage.client.ClientStorageProviderFactory;
import org.keycloak.storage.client.ClientStorageProviderModel;
import org.keycloak.utils.ServicesUtils;

public class ClientStorageManager
implements ClientProvider {
    private static final Logger logger = Logger.getLogger(ClientStorageManager.class);
    protected KeycloakSession session;
    private long clientStorageProviderTimeout;

    public static boolean isStorageProviderEnabled(RealmModel realm, String providerId) {
        ClientStorageProviderModel model = ClientStorageManager.getStorageProviderModel(realm, providerId);
        return model.isEnabled();
    }

    public static ClientStorageProviderModel getStorageProviderModel(RealmModel realm, String componentId) {
        ComponentModel model = realm.getComponent(componentId);
        if (model == null) {
            return null;
        }
        return new ClientStorageProviderModel(model);
    }

    public static ClientStorageProvider getStorageProvider(KeycloakSession session, RealmModel realm, String componentId) {
        ComponentModel model = realm.getComponent(componentId);
        if (model == null) {
            return null;
        }
        ClientStorageProviderModel storageModel = new ClientStorageProviderModel(model);
        ClientStorageProviderFactory factory = (ClientStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientStorageProvider.class, model.getProviderId());
        if (factory == null) {
            throw new ModelException("Could not find ClientStorageProviderFactory for: " + model.getProviderId());
        }
        return ClientStorageManager.getStorageProviderInstance(session, storageModel, factory);
    }

    private static <T> Stream<ClientStorageProviderModel> getStorageProviders(RealmModel realm, KeycloakSession session, Class<T> type) {
        return realm.getClientStorageProvidersStream().filter(model -> {
            ClientStorageProviderFactory factory = ClientStorageManager.getClientStorageProviderFactory(model, session);
            if (factory == null) {
                logger.warnv("Configured ClientStorageProvider {0} of provider id {1} does not exist in realm {2}", (Object)model.getName(), (Object)model.getProviderId(), (Object)realm.getName());
                return false;
            }
            return Types.supports((Class)type, (Object)factory, ClientStorageProviderFactory.class);
        });
    }

    public static ClientStorageProvider getStorageProviderInstance(KeycloakSession session, ClientStorageProviderModel model, ClientStorageProviderFactory factory) {
        ClientStorageProvider instance = (ClientStorageProvider)session.getAttribute(model.getId());
        if (instance != null) {
            return instance;
        }
        instance = factory.create(session, (ComponentModel)model);
        if (instance == null) {
            throw new IllegalStateException("ClientStorageProvideFactory (of type " + factory.getClass().getName() + ") produced a null instance");
        }
        session.enlistForClose((Provider)instance);
        session.setAttribute(model.getId(), (Object)instance);
        return instance;
    }

    public static <T> Stream<T> getStorageProviders(KeycloakSession session, RealmModel realm, Class<T> type) {
        return ClientStorageManager.getStorageProviders(realm, session, type).map(model -> type.cast(ClientStorageManager.getStorageProviderInstance(session, model, ClientStorageManager.getClientStorageProviderFactory(model, session))));
    }

    private static ClientStorageProviderFactory getClientStorageProviderFactory(ClientStorageProviderModel model, KeycloakSession session) {
        return (ClientStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientStorageProvider.class, model.getProviderId());
    }

    public static <T> Stream<T> getEnabledStorageProviders(KeycloakSession session, RealmModel realm, Class<T> type) {
        return ClientStorageManager.getStorageProviders(realm, session, type).filter(ClientStorageProviderModel::isEnabled).map(model -> type.cast(ClientStorageManager.getStorageProviderInstance(session, model, ClientStorageManager.getClientStorageProviderFactory(model, session))));
    }

    public ClientStorageManager(KeycloakSession session, long clientStorageProviderTimeout) {
        this.session = session;
        this.clientStorageProviderTimeout = clientStorageProviderTimeout;
    }

    public ClientModel getClientById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        if (storageId.getProviderId() == null) {
            return this.session.clientLocalStorage().getClientById(realm, id);
        }
        ClientStorageProvider provider = ClientStorageManager.getStorageProvider(this.session, realm, storageId.getProviderId());
        if (provider == null) {
            return null;
        }
        if (!ClientStorageManager.isStorageProviderEnabled(realm, storageId.getProviderId())) {
            return null;
        }
        return provider.getClientById(realm, id);
    }

    public ClientModel getClientByClientId(RealmModel realm, String clientId) {
        ClientModel client = this.session.clientLocalStorage().getClientByClientId(realm, clientId);
        if (client != null) {
            return client;
        }
        return ClientStorageManager.getEnabledStorageProviders(this.session, realm, ClientLookupProvider.class).map(provider -> provider.getClientByClientId(realm, clientId)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Stream<ClientModel> searchClientsByClientIdStream(RealmModel realm, String clientId, Integer firstResult, Integer maxResults) {
        Stream local = this.session.clientLocalStorage().searchClientsByClientIdStream(realm, clientId, firstResult, maxResults);
        Stream ext = ClientStorageManager.getEnabledStorageProviders(this.session, realm, ClientLookupProvider.class).flatMap(ServicesUtils.timeBound(this.session, this.clientStorageProviderTimeout, p -> ((ClientLookupProvider)p).searchClientsByClientIdStream(realm, clientId, firstResult, maxResults)));
        return Stream.concat(local, ext);
    }

    public Map<String, ClientScopeModel> getClientScopes(RealmModel realm, ClientModel client, boolean defaultScopes) {
        StorageId storageId = new StorageId(client.getId());
        if (storageId.getProviderId() == null) {
            return this.session.clientLocalStorage().getClientScopes(realm, client, defaultScopes);
        }
        ClientStorageProvider provider = ClientStorageManager.getStorageProvider(this.session, client.getRealm(), storageId.getProviderId());
        if (provider == null) {
            return null;
        }
        if (!ClientStorageManager.isStorageProviderEnabled(client.getRealm(), storageId.getProviderId())) {
            return null;
        }
        return provider.getClientScopes(realm, client, defaultScopes);
    }

    public ClientModel addClient(RealmModel realm, String clientId) {
        return this.session.clientLocalStorage().addClient(realm, clientId);
    }

    public ClientModel addClient(RealmModel realm, String id, String clientId) {
        return this.session.clientLocalStorage().addClient(realm, id, clientId);
    }

    public Stream<ClientModel> getClientsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.session.clientLocalStorage().getClientsStream(realm, firstResult, maxResults);
    }

    public Stream<ClientModel> getClientsStream(RealmModel realm) {
        return this.session.clientLocalStorage().getClientsStream(realm);
    }

    public long getClientsCount(RealmModel realm) {
        return this.session.clientLocalStorage().getClientsCount(realm);
    }

    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream(RealmModel realm) {
        return this.session.clientLocalStorage().getAlwaysDisplayInConsoleClientsStream(realm);
    }

    public void removeClients(RealmModel realm) {
        this.session.clientLocalStorage().removeClients(realm);
    }

    public void addClientScopes(RealmModel realm, ClientModel client, Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        if (!StorageId.isLocalStorage((String)client.getId())) {
            throw new RuntimeException("Federated clients do not support this operation");
        }
        this.session.clientLocalStorage().addClientScopes(realm, client, clientScopes, defaultScope);
    }

    public void removeClientScope(RealmModel realm, ClientModel client, ClientScopeModel clientScope) {
        if (!StorageId.isLocalStorage((String)client.getId())) {
            throw new RuntimeException("Federated clients do not support this operation");
        }
        this.session.clientLocalStorage().removeClientScope(realm, client, clientScope);
    }

    public void close() {
    }

    public boolean removeClient(RealmModel realm, String id) {
        if (!StorageId.isLocalStorage((String)id)) {
            throw new RuntimeException("Federated clients do not support this operation");
        }
        return this.session.clientLocalStorage().removeClient(realm, id);
    }
}

