/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner.bootstrap;

import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;

public class RunningQuarkusApplicationImpl
implements RunningQuarkusApplication {
    private final Closeable closeTask;
    private final ClassLoader classLoader;
    private boolean closing;

    public RunningQuarkusApplicationImpl(Closeable closeTask, ClassLoader classLoader) {
        this.closeTask = closeTask;
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void close() throws Exception {
        if (!this.closing) {
            this.closing = true;
            this.closeTask.close();
        }
    }

    public <T> Optional<T> getConfigValue(String key, Class<T> type) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> configProviderClass = this.classLoader.loadClass(ConfigProvider.class.getName());
            Method getConfig = configProviderClass.getMethod("getConfig", ClassLoader.class);
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object config = getConfig.invoke(null, this.classLoader);
            Optional optional = (Optional)getConfig.getReturnType().getMethod("getOptionalValue", String.class, Class.class).invoke(config, key, type);
            return optional;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public Iterable<String> getConfigKeys() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> configProviderClass = this.classLoader.loadClass(ConfigProvider.class.getName());
            Method getConfig = configProviderClass.getMethod("getConfig", ClassLoader.class);
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object config = getConfig.invoke(null, this.classLoader);
            Iterable iterable = (Iterable)getConfig.getReturnType().getMethod("getPropertyNames", new Class[0]).invoke(config, new Object[0]);
            return iterable;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public Object instance(Class<?> clazz, Annotation ... qualifiers) {
        try {
            Class<?> actualClass = Class.forName(clazz.getName(), true, this.classLoader);
            Class<?> cdi = this.classLoader.loadClass("javax.enterprise.inject.spi.CDI");
            Object instance = cdi.getMethod("current", new Class[0]).invoke(null, new Object[0]);
            Method selectMethod = cdi.getMethod("select", Class.class, Annotation[].class);
            Object cdiInstance = selectMethod.invoke(instance, actualClass, qualifiers);
            return selectMethod.getReturnType().getMethod("get", new Class[0]).invoke(cdiInstance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

