/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.visibleassertions;

import java.util.concurrent.Callable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.rnorth.ansi.AnsiLite;
import org.rnorth.visibleassertions.AnsiSupport;

public class VisibleAssertions
extends AnsiSupport {
    private static final String TICK_MARK = "\u2714";
    private static final String CROSS_MARK = "\u2718";
    private static final String INFO_MARK = "\u2139\ufe0e";
    private static final String WARN_MARK = "\u26a0\ufe0e";
    private static final String CONTEXT_MARK = "\u2508";

    protected VisibleAssertions() {
    }

    public static void info(String message) {
        if (Boolean.getBoolean("visibleassertions.silence")) {
            return;
        }
        System.out.println("        " + AnsiLite.white(AnsiLite.bright("\u2139\ufe0e " + message)));
    }

    public static void warn(String message) {
        if (Boolean.getBoolean("visibleassertions.silence")) {
            return;
        }
        System.out.println("        " + AnsiLite.yellow(AnsiLite.bright("\u26a0\ufe0e " + message)));
    }

    public static void context(CharSequence context) {
        VisibleAssertions.context(context, 0);
    }

    public static void context(CharSequence context, int indent) {
        int i;
        if (Boolean.getBoolean("visibleassertions.silence")) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        for (i = 0; i < 4; ++i) {
            sb.append(CONTEXT_MARK);
        }
        sb.append(" ");
        sb.append(context);
        int terminalWidth = VisibleAssertions.terminalWidth();
        sb.append(" ");
        for (int i2 = sb.length(); i2 < terminalWidth; ++i2) {
            sb.append(CONTEXT_MARK);
        }
        System.out.println(AnsiLite.dim(sb.toString()));
    }

    public static void assertTrue(String message, boolean value) {
        if (value) {
            VisibleAssertions.pass(message);
        } else {
            VisibleAssertions.fail(message, null);
        }
    }

    public static void assertFalse(String message, boolean value) {
        if (!value) {
            VisibleAssertions.pass(message);
        } else {
            VisibleAssertions.fail(message, null);
        }
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        String expectedInQuotes = VisibleAssertions.inQuotesIfNotNull(expected);
        String actualInQuotes = VisibleAssertions.inQuotesIfNotNull(actual);
        if (VisibleAssertions.areBothNull(expected, actual)) {
            VisibleAssertions.pass(message);
        } else if (VisibleAssertions.isObjectEquals(expected, actual)) {
            VisibleAssertions.pass(message);
        } else if (VisibleAssertions.isObjectStringEqualsButDifferentType(expected, actual)) {
            String actualClass = actual.getClass().getCanonicalName();
            String expectedClass = expected.getClass().getCanonicalName();
            VisibleAssertions.fail(message, actualInQuotes + " [" + actualClass + "] does not equal expected " + expectedInQuotes + " [" + expectedClass + "]");
        } else {
            VisibleAssertions.fail(message, actualInQuotes + " does not equal expected " + expectedInQuotes);
        }
    }

    public static void assertVisiblyEquals(String message, Object expected, Object actual) {
        String expectedInQuotes = VisibleAssertions.inQuotesIfNotNull(expected);
        String actualInQuotes = VisibleAssertions.inQuotesIfNotNull(actual);
        if (VisibleAssertions.areBothNull(expected, actual)) {
            VisibleAssertions.pass(message);
        } else if (VisibleAssertions.isObjectEquals(String.valueOf(expected), String.valueOf(actual))) {
            VisibleAssertions.pass(message);
        } else {
            VisibleAssertions.fail(message, actualInQuotes + " after toString() does not equal expected " + expectedInQuotes);
        }
    }

    public static void assertRoughlyEquals(String message, Double expected, Double actual, Double epsilon) {
        String expectedInQuotes = VisibleAssertions.inQuotesIfNotNull(expected);
        String actualInQuotes = VisibleAssertions.inQuotesIfNotNull(actual);
        if (VisibleAssertions.areBothNull(expected, actual)) {
            VisibleAssertions.pass(message);
        } else if (Math.abs(actual - expected) < epsilon) {
            VisibleAssertions.pass(message);
        } else {
            VisibleAssertions.fail(message, actualInQuotes + " differs from expected " + expectedInQuotes + " by more than allowed amount (" + epsilon + ")");
        }
    }

    public static void assertNotEquals(String message, Object expected, Object actual) {
        if (VisibleAssertions.areBothNull(expected, actual)) {
            VisibleAssertions.fail(message);
        } else if (VisibleAssertions.isObjectEquals(expected, actual)) {
            VisibleAssertions.fail(message);
        } else {
            VisibleAssertions.pass(message);
        }
    }

    private static boolean areBothNull(Object expected, Object actual) {
        return expected == null && actual == null;
    }

    private static boolean isObjectEquals(Object expected, Object actual) {
        return expected != null && expected.equals(actual);
    }

    private static boolean isObjectStringEqualsButDifferentType(Object expected, Object actual) {
        if (expected == null || actual == null) {
            return false;
        }
        String expectedAsString = String.valueOf(expected);
        String actualAsString = String.valueOf(actual);
        return actualAsString.equals(expectedAsString);
    }

    private static String inQuotesIfNotNull(Object value) {
        return value == null ? "null" : "'" + String.valueOf(value) + "'";
    }

    public static void assertNull(String message, Object o) {
        if (o == null) {
            VisibleAssertions.pass(message);
        } else {
            VisibleAssertions.fail(message, "'" + o + "' is not null");
        }
    }

    public static void assertNotNull(String message, Object o) {
        if (o != null) {
            VisibleAssertions.pass(message);
        } else {
            VisibleAssertions.fail(message, null);
        }
    }

    public static void assertSame(String message, Object expected, Object actual) {
        String expectedInQuotes = VisibleAssertions.inQuotesIfNotNull(expected);
        String actualInQuotes = VisibleAssertions.inQuotesIfNotNull(actual);
        if (expected == actual) {
            VisibleAssertions.pass(message);
        } else {
            VisibleAssertions.fail(message, actualInQuotes + " is not the same (!=) as expected " + expectedInQuotes);
        }
    }

    public static void fail(String message) {
        VisibleAssertions.fail(message, null);
    }

    public static <T> void assertThat(String whatTheObjectIs, T actual, Matcher<? super T> matcher) {
        StringDescription description = new StringDescription();
        if (matcher.matches(actual)) {
            description.appendText(whatTheObjectIs);
            description.appendText(" ");
            matcher.describeTo((Description)description);
            VisibleAssertions.pass(description.toString());
        } else {
            description.appendText("asserted that it ").appendDescriptionOf(matcher).appendText(" but ");
            matcher.describeMismatch(actual, (Description)description);
            VisibleAssertions.fail("assertion on " + whatTheObjectIs + " failed", description.toString());
        }
    }

    public static <T> void assertThrows(String message, Class<? extends Exception> exceptionClass, Callable<T> callable) {
        block2: {
            try {
                T result = callable.call();
                VisibleAssertions.fail(message, "No exception was thrown (expected " + exceptionClass.getSimpleName() + " but '" + result + "' was returned instead)");
            }
            catch (Exception e) {
                if (e.getClass().equals(exceptionClass)) break block2;
                VisibleAssertions.fail(message, e.getClass().getSimpleName() + " was thrown instead of " + exceptionClass.getSimpleName());
            }
        }
        VisibleAssertions.pass(message);
    }

    public static void assertThrows(String message, Class<? extends Exception> exceptionClass, Runnable runnable) {
        block2: {
            try {
                runnable.run();
                VisibleAssertions.fail(message, "No exception was thrown (expected " + exceptionClass.getSimpleName() + ")");
            }
            catch (Exception e) {
                if (e.getClass().equals(exceptionClass)) break block2;
                VisibleAssertions.fail(message, e.getClass().getSimpleName() + " was thrown instead of " + exceptionClass.getSimpleName());
            }
        }
        VisibleAssertions.pass(message);
    }

    public static void pass(String message) {
        if (Boolean.getBoolean("visibleassertions.silence") || Boolean.getBoolean("visibleassertions.silence.passes")) {
            return;
        }
        System.out.println("        " + AnsiLite.green("\u2714 " + message));
    }

    public static void fail(String message, String hint) {
        if (Boolean.getBoolean("visibleassertions.silence") || Boolean.getBoolean("visibleassertions.silence.failures")) {
            return;
        }
        System.out.println("        " + AnsiLite.red("\u2718 " + message));
        if (hint == null) {
            throw new AssertionError((Object)message);
        }
        System.out.println("            " + AnsiLite.yellow(hint));
        throw new AssertionError((Object)(message + ": " + hint));
    }
}

