/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.constants.JacksonConstants;
import io.smallrye.openapi.api.constants.JaxbConstants;
import io.smallrye.openapi.api.constants.JsonbConstants;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class IgnoreResolver {
    private final AugmentedIndexView index;
    private final IgnoreAnnotationHandler[] ignoreHandlers;

    public IgnoreResolver(AugmentedIndexView index) {
        this.index = index;
        this.ignoreHandlers = new IgnoreAnnotationHandler[]{new SchemaHiddenHandler(), new JsonbTransientHandler(), new JsonIgnorePropertiesHandler(), new JsonIgnoreHandler(), new JsonIgnoreTypeHandler(), new TransientIgnoreHandler(), new JaxbAccessibilityHandler()};
    }

    public Visibility isIgnore(AnnotationTarget annotationTarget, AnnotationTarget reference) {
        for (IgnoreAnnotationHandler handler : this.ignoreHandlers) {
            Visibility v = handler.shouldIgnore(annotationTarget, reference);
            if (v == Visibility.UNSET) continue;
            return v;
        }
        return Visibility.UNSET;
    }

    public ClassInfo getClassInfoFromIndex(Type type) {
        return this.index.getClass(type);
    }

    private boolean valueAsBooleanOrTrue(AnnotationInstance annotation) {
        return Optional.ofNullable(annotation.value()).map(AnnotationValue::asBoolean).orElse(true);
    }

    private static interface IgnoreAnnotationHandler {
        public Visibility shouldIgnore(AnnotationTarget var1, AnnotationTarget var2);

        public DotName getName();
    }

    private final class JaxbAccessibilityHandler
    implements IgnoreAnnotationHandler {
        private JaxbAccessibilityHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            short flags;
            ClassInfo declaringClass;
            String accessTypeRequired;
            if (this.hasXmlTransient(target)) {
                return Visibility.IGNORED;
            }
            switch (target.kind()) {
                case FIELD: {
                    FieldInfo field = target.asField();
                    accessTypeRequired = "FIELD";
                    declaringClass = field.declaringClass();
                    flags = field.flags();
                    break;
                }
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    accessTypeRequired = "PROPERTY";
                    declaringClass = method.declaringClass();
                    flags = method.flags();
                    break;
                }
                default: {
                    return Visibility.UNSET;
                }
            }
            Visibility result = this.hasXmlTransient((AnnotationTarget)declaringClass) ? Visibility.IGNORED : this.getXmlVisibility(declaringClass, accessTypeRequired, flags);
            return result;
        }

        boolean hasXmlTransient(AnnotationTarget target) {
            return TypeUtil.hasAnnotation(target, JaxbConstants.XML_TRANSIENT);
        }

        Visibility getXmlVisibility(ClassInfo declaringClass, String accessTypeRequired, int flags) {
            String xmlAccessType = (String)TypeUtil.getAnnotationValue((AnnotationTarget)declaringClass, JaxbConstants.XML_ACCESSOR_TYPE);
            if (xmlAccessType == null) {
                return Visibility.UNSET;
            }
            if (accessTypeRequired.equals(xmlAccessType) || "PUBLIC_MEMBER".equals(xmlAccessType) && Modifier.isPublic(flags)) {
                return Visibility.EXPOSED;
            }
            return Visibility.IGNORED;
        }

        @Override
        public DotName getName() {
            return null;
        }
    }

    private final class TransientIgnoreHandler
    implements IgnoreAnnotationHandler {
        private TransientIgnoreHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            FieldInfo field;
            if (target.kind() == AnnotationTarget.Kind.FIELD && Modifier.isTransient((field = target.asField()).flags())) {
                Boolean hidden;
                AnnotationInstance schemaAnnotation = TypeUtil.getSchemaAnnotation(target);
                if (schemaAnnotation != null && (hidden = (Boolean)JandexUtil.value(schemaAnnotation, "hidden")) != null && !hidden.booleanValue()) {
                    return Visibility.EXPOSED;
                }
                return Visibility.IGNORED;
            }
            return Visibility.UNSET;
        }

        @Override
        public DotName getName() {
            return DotName.createSimple((String)TransientIgnoreHandler.class.getName());
        }
    }

    private final class JsonIgnoreTypeHandler
    implements IgnoreAnnotationHandler {
        private final Set<DotName> ignoredTypes = new LinkedHashSet<DotName>();

        private JsonIgnoreTypeHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            Type classType;
            switch (target.kind()) {
                case FIELD: {
                    classType = target.asField().type();
                    break;
                }
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    if (method.returnType().kind().equals((Object)Type.Kind.VOID)) {
                        if (method.parameters().isEmpty()) {
                            return Visibility.IGNORED;
                        }
                        classType = (Type)method.parameters().get(0);
                        break;
                    }
                    classType = method.returnType();
                    break;
                }
                default: {
                    return Visibility.UNSET;
                }
            }
            if (classType.kind() == Type.Kind.PRIMITIVE || classType.kind() == Type.Kind.VOID || classType.kind() == Type.Kind.ARRAY && classType.asArrayType().component().kind() == Type.Kind.PRIMITIVE || !IgnoreResolver.this.index.containsClass(classType)) {
                return Visibility.UNSET;
            }
            ClassInfo classInfo = IgnoreResolver.this.index.getClass(classType);
            if (this.ignoredTypes.contains(classInfo.name())) {
                DataObjectLogging.logger.ignoringType(classInfo.name());
                return Visibility.IGNORED;
            }
            AnnotationInstance annotationInstance = TypeUtil.getAnnotation(classInfo, this.getName());
            if (annotationInstance != null && IgnoreResolver.this.valueAsBooleanOrTrue(annotationInstance)) {
                DataObjectLogging.logger.ignoringTypeAndAddingToSet(classInfo.name());
                this.ignoredTypes.add(classInfo.name());
                return Visibility.IGNORED;
            }
            return Visibility.UNSET;
        }

        @Override
        public DotName getName() {
            return JacksonConstants.JSON_IGNORE_TYPE;
        }
    }

    private final class JsonIgnoreHandler
    implements IgnoreAnnotationHandler {
        private JsonIgnoreHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            AnnotationInstance annotationInstance = TypeUtil.getAnnotation(target, this.getName());
            if (annotationInstance != null && IgnoreResolver.this.valueAsBooleanOrTrue(annotationInstance)) {
                return Visibility.IGNORED;
            }
            return Visibility.UNSET;
        }

        @Override
        public DotName getName() {
            return JacksonConstants.JSON_IGNORE;
        }
    }

    private final class JsonIgnorePropertiesHandler
    implements IgnoreAnnotationHandler {
        private JsonIgnorePropertiesHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            Visibility visibility = this.declaringClassIgnore(target);
            if (visibility != Visibility.UNSET) {
                return visibility;
            }
            return this.nestingPropertyIgnore(reference, this.propertyName(target));
        }

        private Visibility declaringClassIgnore(AnnotationTarget target) {
            AnnotationInstance declaringClassJIP = TypeUtil.getAnnotation(TypeUtil.getDeclaringClass(target), this.getName());
            return this.shouldIgnoreTarget(declaringClassJIP, this.propertyName(target));
        }

        private Visibility nestingPropertyIgnore(AnnotationTarget nesting, String propertyName) {
            if (nesting == null) {
                return Visibility.UNSET;
            }
            AnnotationInstance nestedTypeJIP = TypeUtil.getAnnotation(nesting, this.getName());
            return this.shouldIgnoreTarget(nestedTypeJIP, propertyName);
        }

        private String propertyName(AnnotationTarget target) {
            if (target.kind() == AnnotationTarget.Kind.FIELD) {
                return target.asField().name();
            }
            return TypeResolver.propertyName(target.asMethod());
        }

        private Visibility shouldIgnoreTarget(AnnotationInstance jipAnnotation, String targetName) {
            if (jipAnnotation == null || jipAnnotation.value() == null) {
                return Visibility.UNSET;
            }
            if (Arrays.asList(jipAnnotation.value().asStringArray()).contains(targetName)) {
                return Visibility.IGNORED;
            }
            return Visibility.EXPOSED;
        }

        @Override
        public DotName getName() {
            return JacksonConstants.JSON_IGNORE_PROPERTIES;
        }
    }

    private final class JsonbTransientHandler
    implements IgnoreAnnotationHandler {
        private JsonbTransientHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            return TypeUtil.hasAnnotation(target, this.getName()) ? Visibility.IGNORED : Visibility.UNSET;
        }

        @Override
        public DotName getName() {
            return JsonbConstants.JSONB_TRANSIENT;
        }
    }

    private final class SchemaHiddenHandler
    implements IgnoreAnnotationHandler {
        private SchemaHiddenHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            Boolean hidden;
            AnnotationInstance annotationInstance = TypeUtil.getAnnotation(target, this.getName());
            if (annotationInstance != null && (hidden = (Boolean)JandexUtil.value(annotationInstance, "hidden")) != null) {
                return hidden != false ? Visibility.IGNORED : Visibility.EXPOSED;
            }
            return Visibility.UNSET;
        }

        @Override
        public DotName getName() {
            return SchemaConstant.DOTNAME_SCHEMA;
        }
    }

    public static enum Visibility {
        IGNORED,
        EXPOSED,
        UNSET;

    }
}

