/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Evaluator;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.Futures;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.Resolver;
import io.quarkus.qute.Results;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.ValueResolver;
import io.smallrye.mutiny.Uni;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.logging.Logger;

class EvaluatorImpl
implements Evaluator {
    private static final Logger LOGGER = Logger.getLogger(EvaluatorImpl.class);
    private final List<ValueResolver> resolvers;

    EvaluatorImpl(List<ValueResolver> valueResolvers) {
        this.resolvers = valueResolvers;
    }

    @Override
    public CompletionStage<Object> evaluate(Expression expression, ResolutionContext resolutionContext) {
        if (expression.hasNamespace()) {
            Iterator<Expression.Part> parts = expression.getParts().iterator();
            NamespaceResolver resolver = this.findNamespaceResolver(expression.getNamespace(), resolutionContext);
            if (resolver == null) {
                LOGGER.errorf("No namespace resolver found for: %s", (Object)expression.getNamespace());
                return Futures.failure(new TemplateException("No resolver for namespace: " + expression.getNamespace()));
            }
            EvalContextImpl context = new EvalContextImpl(false, null, parts.next(), resolutionContext);
            LOGGER.debugf("Found '%s' namespace resolver: %s", (Object)expression.getNamespace(), resolver.getClass());
            return resolver.resolve(context).thenCompose(r -> {
                if (parts.hasNext()) {
                    return this.resolveReference(false, r, parts, resolutionContext);
                }
                return this.toCompletionStage(r);
            });
        }
        if (expression.isLiteral()) {
            return expression.getLiteralValue();
        }
        Iterator<Expression.Part> parts = expression.getParts().iterator();
        return this.resolveReference(true, resolutionContext.getData(), parts, resolutionContext);
    }

    private NamespaceResolver findNamespaceResolver(String namespace, ResolutionContext resolutionContext) {
        if (resolutionContext == null) {
            return null;
        }
        if (resolutionContext.getNamespaceResolvers() != null) {
            for (NamespaceResolver resolver : resolutionContext.getNamespaceResolvers()) {
                if (!resolver.getNamespace().equals(namespace)) continue;
                return resolver;
            }
        }
        return this.findNamespaceResolver(namespace, resolutionContext.getParent());
    }

    private CompletionStage<Object> resolveReference(boolean tryParent, Object ref, Iterator<Expression.Part> parts, ResolutionContext resolutionContext) {
        Expression.Part part = parts.next();
        EvalContextImpl evalContext = new EvalContextImpl(tryParent, ref, part, resolutionContext);
        if (!parts.hasNext()) {
            return this.resolve(evalContext, null, true);
        }
        return this.resolve(evalContext, null, true).thenCompose(r -> this.resolveReference(false, r, parts, resolutionContext));
    }

    private CompletionStage<Object> resolve(EvalContextImpl evalContext, Iterator<ValueResolver> resolvers, boolean tryCachedResolver) {
        ValueResolver cachedResolver;
        if (tryCachedResolver && (cachedResolver = evalContext.getCachedResolver()) != null && cachedResolver.appliesTo(evalContext)) {
            return cachedResolver.resolve(evalContext).thenCompose(r -> {
                if (Results.Result.NOT_FOUND.equals(r)) {
                    return this.resolve(evalContext, null, false);
                }
                return this.toCompletionStage(r);
            });
        }
        if (resolvers == null) {
            resolvers = this.resolvers.iterator();
        }
        Resolver applicableResolver = null;
        while (applicableResolver == null && resolvers.hasNext()) {
            ValueResolver next = resolvers.next();
            if (!next.appliesTo(evalContext)) continue;
            applicableResolver = next;
        }
        if (applicableResolver == null) {
            ResolutionContext parent = evalContext.resolutionContext.getParent();
            if (evalContext.tryParent && parent != null) {
                return this.resolve(new EvalContextImpl(true, parent.getData(), parent, evalContext.part), null, false);
            }
            LOGGER.tracef("Unable to resolve %s", (Object)evalContext);
            return Results.NOT_FOUND;
        }
        Iterator<ValueResolver> remainingResolvers = resolvers;
        Resolver foundResolver = applicableResolver;
        return applicableResolver.resolve(evalContext).thenCompose(arg_0 -> this.lambda$resolve$3(evalContext, remainingResolvers, (ValueResolver)foundResolver, arg_0));
    }

    private CompletionStage<Object> toCompletionStage(Object result) {
        if (result instanceof CompletionStage) {
            return (CompletionStage)result;
        }
        if (result instanceof Uni) {
            return ((Uni)result).subscribeAsCompletionStage();
        }
        return CompletableFuture.completedFuture(result);
    }

    private /* synthetic */ CompletionStage lambda$resolve$3(EvalContextImpl evalContext, Iterator remainingResolvers, ValueResolver foundResolver, Object r) {
        if (Results.Result.NOT_FOUND.equals(r)) {
            return this.resolve(evalContext, remainingResolvers, false);
        }
        evalContext.setCachedResolver(foundResolver);
        return this.toCompletionStage(r);
    }

    static class EvalContextImpl
    implements EvalContext {
        final boolean tryParent;
        final Object base;
        final ResolutionContext resolutionContext;
        final ExpressionImpl.PartImpl part;

        EvalContextImpl(boolean tryParent, Object base, Expression.Part part, ResolutionContext resolutionContext) {
            this(tryParent, base, resolutionContext, part);
        }

        EvalContextImpl(boolean tryParent, Object base, ResolutionContext resolutionContext, Expression.Part part) {
            this.tryParent = tryParent;
            this.base = base;
            this.resolutionContext = resolutionContext;
            this.part = (ExpressionImpl.PartImpl)part;
        }

        @Override
        public Object getBase() {
            return this.base;
        }

        @Override
        public String getName() {
            return this.part.getName();
        }

        @Override
        public List<Expression> getParams() {
            return this.part.isVirtualMethod() ? this.part.asVirtualMethod().getParameters() : Collections.emptyList();
        }

        @Override
        public CompletionStage<Object> evaluate(String value) {
            return this.evaluate(ExpressionImpl.from(value));
        }

        @Override
        public CompletionStage<Object> evaluate(Expression expression) {
            return this.resolutionContext.evaluate(expression);
        }

        @Override
        public Object getAttribute(String key) {
            return this.resolutionContext.getAttribute(key);
        }

        ValueResolver getCachedResolver() {
            return this.part.cachedResolver;
        }

        void setCachedResolver(ValueResolver valueResolver) {
            this.part.cachedResolver = valueResolver;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EvalContextImpl [tryParent=").append(this.tryParent).append(", base=").append(this.base).append(", name=").append(this.getBase()).append(", params=").append(this.getParams()).append("]");
            return builder.toString();
        }
    }
}

