/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.security.SecureRandom;
import java.util.Random;
import org.keycloak.common.util.RandomString;
import org.keycloak.models.OAuth2DeviceUserCodeProvider;

public class DefaultOAuth2DeviceUserCodeProvider
implements OAuth2DeviceUserCodeProvider {
    private static final int LENGTH = 8;
    private static final String DELIMITER = "-";

    @Override
    public String generate() {
        return new RandomString(8, (Random)new SecureRandom(), "ABCDEFGHIJKLMNOPQRSTUVWXYZ").nextString();
    }

    @Override
    public String display(String userCode) {
        return new StringBuilder(userCode).insert(4, DELIMITER).toString();
    }

    @Override
    public String format(String userCode) {
        return String.join((CharSequence)"", userCode.split(DELIMITER)).toUpperCase();
    }

    public void close() {
    }
}

