/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.util.List;
import javax.ws.rs.POST;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.TokenIntrospectContext;

public class TokenIntrospectionEndpoint {
    private static final String PARAM_TOKEN_TYPE_HINT = "token_type_hint";
    private static final String PARAM_TOKEN = "token";
    @Context
    private KeycloakSession session;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    @Context
    private ClientConnection clientConnection;
    private final RealmModel realm;
    private final EventBuilder event;

    public TokenIntrospectionEndpoint(RealmModel realm, EventBuilder event) {
        this.realm = realm;
        this.event = event;
    }

    @POST
    @NoCache
    public Response introspect() {
        String token;
        this.event.event(EventType.INTROSPECT_TOKEN);
        this.checkSsl();
        this.checkRealm();
        this.authorizeClient();
        MultivaluedMap formParams = this.request.getDecodedFormParameters();
        this.checkParameterDuplicated((MultivaluedMap<String, String>)formParams);
        String tokenTypeHint = (String)formParams.getFirst((Object)PARAM_TOKEN_TYPE_HINT);
        if (tokenTypeHint == null) {
            tokenTypeHint = "access_token";
        }
        if ((token = (String)formParams.getFirst((Object)PARAM_TOKEN)) == null) {
            throw this.throwErrorResponseException("invalid_request", "Token not provided.", Response.Status.BAD_REQUEST);
        }
        TokenIntrospectionProvider provider = (TokenIntrospectionProvider)this.session.getProvider(TokenIntrospectionProvider.class, tokenTypeHint);
        if (provider == null) {
            throw this.throwErrorResponseException("invalid_request", "Unsupported token type [" + tokenTypeHint + "].", Response.Status.BAD_REQUEST);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new TokenIntrospectContext((MultivaluedMap<String, String>)formParams));
        }
        catch (ClientPolicyException cpe) {
            throw this.throwErrorResponseException("invalid_request", cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        try {
            Response response = provider.introspect(token);
            this.event.success();
            return response;
        }
        catch (ErrorResponseException ere) {
            throw ere;
        }
        catch (Exception e) {
            throw this.throwErrorResponseException("invalid_request", "Failed to introspect token.", Response.Status.BAD_REQUEST);
        }
    }

    private void authorizeClient() {
        try {
            ClientModel client = AuthorizeClientUtil.authorizeClient(this.session, this.event, null).getClient();
            this.event.client(client);
            if (client == null || client.isPublicClient()) {
                throw this.throwErrorResponseException("invalid_request", "Client not allowed.", Response.Status.FORBIDDEN);
            }
        }
        catch (ErrorResponseException ere) {
            throw ere;
        }
        catch (Exception e) {
            throw this.throwErrorResponseException("invalid_request", "Authentication failed.", Response.Status.UNAUTHORIZED);
        }
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new ErrorResponseException("invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new ErrorResponseException("access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    private void checkParameterDuplicated(MultivaluedMap<String, String> formParams) {
        for (String key : formParams.keySet()) {
            if (((List)formParams.get((Object)key)).size() == 1) continue;
            throw this.throwErrorResponseException("invalid_request", "duplicated parameter", Response.Status.BAD_REQUEST);
        }
    }

    private ErrorResponseException throwErrorResponseException(String error, String detail, Response.Status status) {
        this.event.detail("detail", detail).error(error);
        return new ErrorResponseException(error, detail, status);
    }
}

